/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.DiskMapMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block storage disk mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskMap implements StructuredPojo, ToCopyableBuilder<DiskMap.Builder, DiskMap> {
    private final String originalDiskPath;

    private final String newDiskName;

    private DiskMap(BuilderImpl builder) {
        this.originalDiskPath = builder.originalDiskPath;
        this.newDiskName = builder.newDiskName;
    }

    /**
     * <p>
     * The original disk path exposed to the instance (for example, <code>/dev/sdh</code>).
     * </p>
     * 
     * @return The original disk path exposed to the instance (for example, <code>/dev/sdh</code>).
     */
    public String originalDiskPath() {
        return originalDiskPath;
    }

    /**
     * <p>
     * The new disk name (e.g., <code>my-new-disk</code>).
     * </p>
     * 
     * @return The new disk name (e.g., <code>my-new-disk</code>).
     */
    public String newDiskName() {
        return newDiskName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(originalDiskPath());
        hashCode = 31 * hashCode + Objects.hashCode(newDiskName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskMap)) {
            return false;
        }
        DiskMap other = (DiskMap) obj;
        return Objects.equals(originalDiskPath(), other.originalDiskPath()) && Objects.equals(newDiskName(), other.newDiskName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (originalDiskPath() != null) {
            sb.append("OriginalDiskPath: ").append(originalDiskPath()).append(",");
        }
        if (newDiskName() != null) {
            sb.append("NewDiskName: ").append(newDiskName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "originalDiskPath":
            return Optional.of(clazz.cast(originalDiskPath()));
        case "newDiskName":
            return Optional.of(clazz.cast(newDiskName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskMapMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DiskMap> {
        /**
         * <p>
         * The original disk path exposed to the instance (for example, <code>/dev/sdh</code>).
         * </p>
         * 
         * @param originalDiskPath
         *        The original disk path exposed to the instance (for example, <code>/dev/sdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalDiskPath(String originalDiskPath);

        /**
         * <p>
         * The new disk name (e.g., <code>my-new-disk</code>).
         * </p>
         * 
         * @param newDiskName
         *        The new disk name (e.g., <code>my-new-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDiskName(String newDiskName);
    }

    static final class BuilderImpl implements Builder {
        private String originalDiskPath;

        private String newDiskName;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskMap model) {
            originalDiskPath(model.originalDiskPath);
            newDiskName(model.newDiskName);
        }

        public final String getOriginalDiskPath() {
            return originalDiskPath;
        }

        @Override
        public final Builder originalDiskPath(String originalDiskPath) {
            this.originalDiskPath = originalDiskPath;
            return this;
        }

        public final void setOriginalDiskPath(String originalDiskPath) {
            this.originalDiskPath = originalDiskPath;
        }

        public final String getNewDiskName() {
            return newDiskName;
        }

        @Override
        public final Builder newDiskName(String newDiskName) {
            this.newDiskName = newDiskName;
            return this;
        }

        public final void setNewDiskName(String newDiskName) {
            this.newDiskName = newDiskName;
        }

        @Override
        public DiskMap build() {
            return new DiskMap(this);
        }
    }
}
