/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.DiskSnapshotMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block storage disk snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskSnapshot implements StructuredPojo, ToCopyableBuilder<DiskSnapshot.Builder, DiskSnapshot> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final Integer sizeInGb;

    private final String state;

    private final String progress;

    private final String fromDiskName;

    private final String fromDiskArn;

    private DiskSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromDiskName = builder.fromDiskName;
        this.fromDiskArn = builder.fromDiskArn;
    }

    /**
     * <p>
     * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     * </p>
     * 
     * @return The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the disk snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the disk snapshot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The date when the disk snapshot was created.
     * </p>
     * 
     * @return The date when the disk snapshot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Region and Availability Zone where the disk snapshot was created.
     * </p>
     * 
     * @return The AWS Region and Availability Zone where the disk snapshot was created.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The size of the disk in GB.
     * </p>
     * 
     * @return The size of the disk in GB.
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * <p>
     * The status of the disk snapshot operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiskSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The status of the disk snapshot operation.
     * @see DiskSnapshotState
     */
    public DiskSnapshotState state() {
        return DiskSnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The status of the disk snapshot operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiskSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The status of the disk snapshot operation.
     * @see DiskSnapshotState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The progress of the disk snapshot operation.
     * </p>
     * 
     * @return The progress of the disk snapshot operation.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The unique name of the source disk from which you are creating the disk snapshot.
     * </p>
     * 
     * @return The unique name of the source disk from which you are creating the disk snapshot.
     */
    public String fromDiskName() {
        return fromDiskName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source disk from which you are creating the disk snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source disk from which you are creating the disk snapshot.
     */
    public String fromDiskArn() {
        return fromDiskArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(fromDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(fromDiskArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskSnapshot)) {
            return false;
        }
        DiskSnapshot other = (DiskSnapshot) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(sizeInGb(), other.sizeInGb()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(progress(), other.progress()) && Objects.equals(fromDiskName(), other.fromDiskName())
                && Objects.equals(fromDiskArn(), other.fromDiskArn());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (sizeInGb() != null) {
            sb.append("SizeInGb: ").append(sizeInGb()).append(",");
        }
        if (stateString() != null) {
            sb.append("State: ").append(stateString()).append(",");
        }
        if (progress() != null) {
            sb.append("Progress: ").append(progress()).append(",");
        }
        if (fromDiskName() != null) {
            sb.append("FromDiskName: ").append(fromDiskName()).append(",");
        }
        if (fromDiskArn() != null) {
            sb.append("FromDiskArn: ").append(fromDiskArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "supportCode":
            return Optional.of(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "sizeInGb":
            return Optional.of(clazz.cast(sizeInGb()));
        case "state":
            return Optional.of(clazz.cast(stateString()));
        case "progress":
            return Optional.of(clazz.cast(progress()));
        case "fromDiskName":
            return Optional.of(clazz.cast(fromDiskName()));
        case "fromDiskArn":
            return Optional.of(clazz.cast(fromDiskArn()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskSnapshotMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DiskSnapshot> {
        /**
         * <p>
         * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * </p>
         * 
         * @param name
         *        The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the disk snapshot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The date when the disk snapshot was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Region and Availability Zone where the disk snapshot was created.
         * </p>
         * 
         * @param location
         *        The AWS Region and Availability Zone where the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The AWS Region and Availability Zone where the disk snapshot was created.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().apply(location).build());
        }

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The size of the disk in GB.
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The status of the disk snapshot operation.
         * </p>
         * 
         * @param state
         *        The status of the disk snapshot operation.
         * @see DiskSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskSnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the disk snapshot operation.
         * </p>
         * 
         * @param state
         *        The status of the disk snapshot operation.
         * @see DiskSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskSnapshotState
         */
        Builder state(DiskSnapshotState state);

        /**
         * <p>
         * The progress of the disk snapshot operation.
         * </p>
         * 
         * @param progress
         *        The progress of the disk snapshot operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The unique name of the source disk from which you are creating the disk snapshot.
         * </p>
         * 
         * @param fromDiskName
         *        The unique name of the source disk from which you are creating the disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskName(String fromDiskName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source disk from which you are creating the disk snapshot.
         * </p>
         * 
         * @param fromDiskArn
         *        The Amazon Resource Name (ARN) of the source disk from which you are creating the disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskArn(String fromDiskArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private Integer sizeInGb;

        private String state;

        private String progress;

        private String fromDiskName;

        private String fromDiskArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskSnapshot model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            sizeInGb(model.sizeInGb);
            state(model.state);
            progress(model.progress);
            fromDiskName(model.fromDiskName);
            fromDiskArn(model.fromDiskArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiskSnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromDiskName() {
            return fromDiskName;
        }

        @Override
        public final Builder fromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
            return this;
        }

        public final void setFromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
        }

        public final String getFromDiskArn() {
            return fromDiskArn;
        }

        @Override
        public final Builder fromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
            return this;
        }

        public final void setFromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
        }

        @Override
        public DiskSnapshot build() {
            return new DiskSnapshot(this);
        }
    }
}
