/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceAccessDetailsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceAccessDetailsResponse.Builder, GetInstanceAccessDetailsResponse> {
    private final InstanceAccessDetails accessDetails;

    private GetInstanceAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.accessDetails = builder.accessDetails;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about a get instance access request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about a get instance access request.
     */
    public InstanceAccessDetails accessDetails() {
        return accessDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsResponse)) {
            return false;
        }
        GetInstanceAccessDetailsResponse other = (GetInstanceAccessDetailsResponse) obj;
        return Objects.equals(accessDetails(), other.accessDetails());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (accessDetails() != null) {
            sb.append("AccessDetails: ").append(accessDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessDetails":
            return Optional.of(clazz.cast(accessDetails()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetInstanceAccessDetailsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about a get instance access request.
         * </p>
         * 
         * @param accessDetails
         *        An array of key-value pairs containing information about a get instance access request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessDetails(InstanceAccessDetails accessDetails);

        /**
         * <p>
         * An array of key-value pairs containing information about a get instance access request.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceAccessDetails.Builder} avoiding the need
         * to create one manually via {@link InstanceAccessDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAccessDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #accessDetails(InstanceAccessDetails)}.
         * 
         * @param accessDetails
         *        a consumer that will call methods on {@link InstanceAccessDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessDetails(InstanceAccessDetails)
         */
        default Builder accessDetails(Consumer<InstanceAccessDetails.Builder> accessDetails) {
            return accessDetails(InstanceAccessDetails.builder().apply(accessDetails).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private InstanceAccessDetails accessDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsResponse model) {
            accessDetails(model.accessDetails);
        }

        public final InstanceAccessDetails.Builder getAccessDetails() {
            return accessDetails != null ? accessDetails.toBuilder() : null;
        }

        @Override
        public final Builder accessDetails(InstanceAccessDetails accessDetails) {
            this.accessDetails = accessDetails;
            return this;
        }

        public final void setAccessDetails(InstanceAccessDetails.BuilderImpl accessDetails) {
            this.accessDetails = accessDetails != null ? accessDetails.build() : null;
        }

        @Override
        public GetInstanceAccessDetailsResponse build() {
            return new GetInstanceAccessDetailsResponse(this);
        }
    }
}
