/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceMetricDataResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceMetricDataResponse.Builder, GetInstanceMetricDataResponse> {
    private final String metricName;

    private final List<MetricDatapoint> metricData;

    private GetInstanceMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The metric name to return data for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link InstanceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameString}.
     * </p>
     * 
     * @return The metric name to return data for.
     * @see InstanceMetricName
     */
    public InstanceMetricName metricName() {
        return InstanceMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The metric name to return data for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link InstanceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameString}.
     * </p>
     * 
     * @return The metric name to return data for.
     * @see InstanceMetricName
     */
    public String metricNameString() {
        return metricName;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance metric data request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance metric data
     *         request.
     */
    public List<MetricDatapoint> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNameString());
        hashCode = 31 * hashCode + Objects.hashCode(metricData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataResponse)) {
            return false;
        }
        GetInstanceMetricDataResponse other = (GetInstanceMetricDataResponse) obj;
        return Objects.equals(metricNameString(), other.metricNameString()) && Objects.equals(metricData(), other.metricData());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (metricNameString() != null) {
            sb.append("MetricName: ").append(metricNameString()).append(",");
        }
        if (metricData() != null) {
            sb.append("MetricData: ").append(metricData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.of(clazz.cast(metricNameString()));
        case "metricData":
            return Optional.of(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetInstanceMetricDataResponse> {
        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(InstanceMetricName metricName);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatapoint> metricData);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatapoint... metricData);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String metricName;

        private List<MetricDatapoint> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataResponse model) {
            metricName(model.metricName);
            metricData(model.metricData);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint.Builder> getMetricData() {
            return metricData != null ? metricData.stream().map(MetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public GetInstanceMetricDataResponse build() {
            return new GetInstanceMetricDataResponse(this);
        }
    }
}
