/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceStateResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceStateResponse.Builder, GetInstanceStateResponse> {
    private final InstanceState state;

    private GetInstanceStateResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
    }

    /**
     * <p>
     * The state of the instance.
     * </p>
     * 
     * @return The state of the instance.
     */
    public InstanceState state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceStateResponse)) {
            return false;
        }
        GetInstanceStateResponse other = (GetInstanceStateResponse) obj;
        return Objects.equals(state(), other.state());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.of(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetInstanceStateResponse> {
        /**
         * <p>
         * The state of the instance.
         * </p>
         * 
         * @param state
         *        The state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The state of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().apply(state).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private InstanceState state;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceStateResponse model) {
            state(model.state);
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public GetInstanceStateResponse build() {
            return new GetInstanceStateResponse(this);
        }
    }
}
