/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance (a virtual private server).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements StructuredPojo, ToCopyableBuilder<Instance.Builder, Instance> {
    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final String blueprintId;

    private final String blueprintName;

    private final String bundleId;

    private final Boolean isStaticIp;

    private final String privateIpAddress;

    private final String publicIpAddress;

    private final String ipv6Address;

    private final InstanceHardware hardware;

    private final InstanceNetworking networking;

    private final InstanceState state;

    private final String username;

    private final String sshKeyName;

    private Instance(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.blueprintId = builder.blueprintId;
        this.blueprintName = builder.blueprintName;
        this.bundleId = builder.bundleId;
        this.isStaticIp = builder.isStaticIp;
        this.privateIpAddress = builder.privateIpAddress;
        this.publicIpAddress = builder.publicIpAddress;
        this.ipv6Address = builder.ipv6Address;
        this.hardware = builder.hardware;
        this.networking = builder.networking;
        this.state = builder.state;
        this.username = builder.username;
        this.sshKeyName = builder.sshKeyName;
    }

    /**
     * <p>
     * The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).
     * </p>
     * 
     * @return The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the instance (e.g.,
     * <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the instance (e.g.,
     *         <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
     * </p>
     * 
     * @return The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region name and availability zone where the instance is located.
     * </p>
     * 
     * @return The region name and availability zone where the instance is located.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The type of resource (usually <code>Instance</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource (usually <code>Instance</code>).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource (usually <code>Instance</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The type of resource (usually <code>Instance</code>).
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
     * </p>
     * 
     * @return The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
     */
    public String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     * </p>
     * 
     * @return The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
     */
    public String blueprintName() {
        return blueprintName;
    }

    /**
     * <p>
     * The bundle for the instance (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle for the instance (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * A Boolean value indicating whether this instance has a static IP assigned to it.
     * </p>
     * 
     * @return A Boolean value indicating whether this instance has a static IP assigned to it.
     */
    public Boolean isStaticIp() {
        return isStaticIp;
    }

    /**
     * <p>
     * The private IP address of the instance.
     * </p>
     * 
     * @return The private IP address of the instance.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The public IP address of the instance.
     * </p>
     * 
     * @return The public IP address of the instance.
     */
    public String publicIpAddress() {
        return publicIpAddress;
    }

    /**
     * <p>
     * The IPv6 address of the instance.
     * </p>
     * 
     * @return The IPv6 address of the instance.
     */
    public String ipv6Address() {
        return ipv6Address;
    }

    /**
     * <p>
     * The size of the vCPU and the amount of RAM for the instance.
     * </p>
     * 
     * @return The size of the vCPU and the amount of RAM for the instance.
     */
    public InstanceHardware hardware() {
        return hardware;
    }

    /**
     * <p>
     * Information about the public ports and monthly data transfer rates for the instance.
     * </p>
     * 
     * @return Information about the public ports and monthly data transfer rates for the instance.
     */
    public InstanceNetworking networking() {
        return networking;
    }

    /**
     * <p>
     * The status code and the state (e.g., <code>running</code>) for the instance.
     * </p>
     * 
     * @return The status code and the state (e.g., <code>running</code>) for the instance.
     */
    public InstanceState state() {
        return state;
    }

    /**
     * <p>
     * The user name for connecting to the instance (e.g., <code>ec2-user</code>).
     * </p>
     * 
     * @return The user name for connecting to the instance (e.g., <code>ec2-user</code>).
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>).
     * </p>
     * 
     * @return The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>
     *         ).
     */
    public String sshKeyName() {
        return sshKeyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(isStaticIp());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(hardware());
        hashCode = 31 * hashCode + Objects.hashCode(networking());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(blueprintName(), other.blueprintName())
                && Objects.equals(bundleId(), other.bundleId()) && Objects.equals(isStaticIp(), other.isStaticIp())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(publicIpAddress(), other.publicIpAddress())
                && Objects.equals(ipv6Address(), other.ipv6Address()) && Objects.equals(hardware(), other.hardware())
                && Objects.equals(networking(), other.networking()) && Objects.equals(state(), other.state())
                && Objects.equals(username(), other.username()) && Objects.equals(sshKeyName(), other.sshKeyName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (supportCode() != null) {
            sb.append("SupportCode: ").append(supportCode()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (blueprintId() != null) {
            sb.append("BlueprintId: ").append(blueprintId()).append(",");
        }
        if (blueprintName() != null) {
            sb.append("BlueprintName: ").append(blueprintName()).append(",");
        }
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        if (isStaticIp() != null) {
            sb.append("IsStaticIp: ").append(isStaticIp()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (publicIpAddress() != null) {
            sb.append("PublicIpAddress: ").append(publicIpAddress()).append(",");
        }
        if (ipv6Address() != null) {
            sb.append("Ipv6Address: ").append(ipv6Address()).append(",");
        }
        if (hardware() != null) {
            sb.append("Hardware: ").append(hardware()).append(",");
        }
        if (networking() != null) {
            sb.append("Networking: ").append(networking()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (username() != null) {
            sb.append("Username: ").append(username()).append(",");
        }
        if (sshKeyName() != null) {
            sb.append("SshKeyName: ").append(sshKeyName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.of(clazz.cast(name()));
        case "arn":
            return Optional.of(clazz.cast(arn()));
        case "supportCode":
            return Optional.of(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "blueprintId":
            return Optional.of(clazz.cast(blueprintId()));
        case "blueprintName":
            return Optional.of(clazz.cast(blueprintName()));
        case "bundleId":
            return Optional.of(clazz.cast(bundleId()));
        case "isStaticIp":
            return Optional.of(clazz.cast(isStaticIp()));
        case "privateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "publicIpAddress":
            return Optional.of(clazz.cast(publicIpAddress()));
        case "ipv6Address":
            return Optional.of(clazz.cast(ipv6Address()));
        case "hardware":
            return Optional.of(clazz.cast(hardware()));
        case "networking":
            return Optional.of(clazz.cast(networking()));
        case "state":
            return Optional.of(clazz.cast(state()));
        case "username":
            return Optional.of(clazz.cast(username()));
        case "sshKeyName":
            return Optional.of(clazz.cast(sshKeyName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).
         * </p>
         * 
         * @param name
         *        The name the user gave the instance (e.g., <code>Amazon_Linux-1GB-Ohio-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the instance (e.g.,
         * <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the instance (e.g.,
         *        <code>arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the instance was created (e.g., <code>1479734909.17</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region name and availability zone where the instance is located.
         * </p>
         * 
         * @param location
         *        The region name and availability zone where the instance is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The region name and availability zone where the instance is located.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().apply(location).build());
        }

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource (usually <code>Instance</code>).
         * </p>
         * 
         * @param resourceType
         *        The type of resource (usually <code>Instance</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
         * </p>
         * 
         * @param blueprintId
         *        The blueprint ID (e.g., <code>os_amlinux_2016_03</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * </p>
         * 
         * @param blueprintName
         *        The friendly name of the blueprint (e.g., <code>Amazon Linux</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintName(String blueprintName);

        /**
         * <p>
         * The bundle for the instance (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle for the instance (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * A Boolean value indicating whether this instance has a static IP assigned to it.
         * </p>
         * 
         * @param isStaticIp
         *        A Boolean value indicating whether this instance has a static IP assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isStaticIp(Boolean isStaticIp);

        /**
         * <p>
         * The private IP address of the instance.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The public IP address of the instance.
         * </p>
         * 
         * @param publicIpAddress
         *        The public IP address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpAddress(String publicIpAddress);

        /**
         * <p>
         * The IPv6 address of the instance.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);

        /**
         * <p>
         * The size of the vCPU and the amount of RAM for the instance.
         * </p>
         * 
         * @param hardware
         *        The size of the vCPU and the amount of RAM for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardware(InstanceHardware hardware);

        /**
         * <p>
         * The size of the vCPU and the amount of RAM for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceHardware.Builder} avoiding the need to
         * create one manually via {@link InstanceHardware#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceHardware.Builder#build()} is called immediately and its
         * result is passed to {@link #hardware(InstanceHardware)}.
         * 
         * @param hardware
         *        a consumer that will call methods on {@link InstanceHardware.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hardware(InstanceHardware)
         */
        default Builder hardware(Consumer<InstanceHardware.Builder> hardware) {
            return hardware(InstanceHardware.builder().apply(hardware).build());
        }

        /**
         * <p>
         * Information about the public ports and monthly data transfer rates for the instance.
         * </p>
         * 
         * @param networking
         *        Information about the public ports and monthly data transfer rates for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networking(InstanceNetworking networking);

        /**
         * <p>
         * Information about the public ports and monthly data transfer rates for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceNetworking.Builder} avoiding the need to
         * create one manually via {@link InstanceNetworking#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceNetworking.Builder#build()} is called immediately and its
         * result is passed to {@link #networking(InstanceNetworking)}.
         * 
         * @param networking
         *        a consumer that will call methods on {@link InstanceNetworking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networking(InstanceNetworking)
         */
        default Builder networking(Consumer<InstanceNetworking.Builder> networking) {
            return networking(InstanceNetworking.builder().apply(networking).build());
        }

        /**
         * <p>
         * The status code and the state (e.g., <code>running</code>) for the instance.
         * </p>
         * 
         * @param state
         *        The status code and the state (e.g., <code>running</code>) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(InstanceState state);

        /**
         * <p>
         * The status code and the state (e.g., <code>running</code>) for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #state(InstanceState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(InstanceState)
         */
        default Builder state(Consumer<InstanceState.Builder> state) {
            return state(InstanceState.builder().apply(state).build());
        }

        /**
         * <p>
         * The user name for connecting to the instance (e.g., <code>ec2-user</code>).
         * </p>
         * 
         * @param username
         *        The user name for connecting to the instance (e.g., <code>ec2-user</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The name of the SSH key being used to connect to the instance (e.g., <code>LightsailDefaultKeyPair</code>).
         * </p>
         * 
         * @param sshKeyName
         *        The name of the SSH key being used to connect to the instance (e.g.,
         *        <code>LightsailDefaultKeyPair</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private String blueprintId;

        private String blueprintName;

        private String bundleId;

        private Boolean isStaticIp;

        private String privateIpAddress;

        private String publicIpAddress;

        private String ipv6Address;

        private InstanceHardware hardware;

        private InstanceNetworking networking;

        private InstanceState state;

        private String username;

        private String sshKeyName;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            blueprintId(model.blueprintId);
            blueprintName(model.blueprintName);
            bundleId(model.bundleId);
            isStaticIp(model.isStaticIp);
            privateIpAddress(model.privateIpAddress);
            publicIpAddress(model.publicIpAddress);
            ipv6Address(model.ipv6Address);
            hardware(model.hardware);
            networking(model.networking);
            state(model.state);
            username(model.username);
            sshKeyName(model.sshKeyName);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBlueprintName() {
            return blueprintName;
        }

        @Override
        public final Builder blueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
            return this;
        }

        public final void setBlueprintName(String blueprintName) {
            this.blueprintName = blueprintName;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final Boolean getIsStaticIp() {
            return isStaticIp;
        }

        @Override
        public final Builder isStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
            return this;
        }

        public final void setIsStaticIp(Boolean isStaticIp) {
            this.isStaticIp = isStaticIp;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getPublicIpAddress() {
            return publicIpAddress;
        }

        @Override
        public final Builder publicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
            return this;
        }

        public final void setPublicIpAddress(String publicIpAddress) {
            this.publicIpAddress = publicIpAddress;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public final InstanceHardware.Builder getHardware() {
            return hardware != null ? hardware.toBuilder() : null;
        }

        @Override
        public final Builder hardware(InstanceHardware hardware) {
            this.hardware = hardware;
            return this;
        }

        public final void setHardware(InstanceHardware.BuilderImpl hardware) {
            this.hardware = hardware != null ? hardware.build() : null;
        }

        public final InstanceNetworking.Builder getNetworking() {
            return networking != null ? networking.toBuilder() : null;
        }

        @Override
        public final Builder networking(InstanceNetworking networking) {
            this.networking = networking;
            return this;
        }

        public final void setNetworking(InstanceNetworking.BuilderImpl networking) {
            this.networking = networking != null ? networking.build() : null;
        }

        public final InstanceState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(InstanceState state) {
            this.state = state;
            return this;
        }

        public final void setState(InstanceState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
