/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceNetworkingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes monthly data transfer rates and port information for an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworking implements StructuredPojo, ToCopyableBuilder<InstanceNetworking.Builder, InstanceNetworking> {
    private final MonthlyTransfer monthlyTransfer;

    private final List<InstancePortInfo> ports;

    private InstanceNetworking(BuilderImpl builder) {
        this.monthlyTransfer = builder.monthlyTransfer;
        this.ports = builder.ports;
    }

    /**
     * <p>
     * The amount of data in GB allocated for monthly data transfers.
     * </p>
     * 
     * @return The amount of data in GB allocated for monthly data transfers.
     */
    public MonthlyTransfer monthlyTransfer() {
        return monthlyTransfer;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the ports on the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the ports on the instance.
     */
    public List<InstancePortInfo> ports() {
        return ports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monthlyTransfer());
        hashCode = 31 * hashCode + Objects.hashCode(ports());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworking)) {
            return false;
        }
        InstanceNetworking other = (InstanceNetworking) obj;
        return Objects.equals(monthlyTransfer(), other.monthlyTransfer()) && Objects.equals(ports(), other.ports());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (monthlyTransfer() != null) {
            sb.append("MonthlyTransfer: ").append(monthlyTransfer()).append(",");
        }
        if (ports() != null) {
            sb.append("Ports: ").append(ports()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monthlyTransfer":
            return Optional.of(clazz.cast(monthlyTransfer()));
        case "ports":
            return Optional.of(clazz.cast(ports()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceNetworkingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworking> {
        /**
         * <p>
         * The amount of data in GB allocated for monthly data transfers.
         * </p>
         * 
         * @param monthlyTransfer
         *        The amount of data in GB allocated for monthly data transfers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyTransfer(MonthlyTransfer monthlyTransfer);

        /**
         * <p>
         * The amount of data in GB allocated for monthly data transfers.
         * </p>
         * This is a convenience that creates an instance of the {@link MonthlyTransfer.Builder} avoiding the need to
         * create one manually via {@link MonthlyTransfer#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonthlyTransfer.Builder#build()} is called immediately and its
         * result is passed to {@link #monthlyTransfer(MonthlyTransfer)}.
         * 
         * @param monthlyTransfer
         *        a consumer that will call methods on {@link MonthlyTransfer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monthlyTransfer(MonthlyTransfer)
         */
        default Builder monthlyTransfer(Consumer<MonthlyTransfer.Builder> monthlyTransfer) {
            return monthlyTransfer(MonthlyTransfer.builder().apply(monthlyTransfer).build());
        }

        /**
         * <p>
         * An array of key-value pairs containing information about the ports on the instance.
         * </p>
         * 
         * @param ports
         *        An array of key-value pairs containing information about the ports on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(Collection<InstancePortInfo> ports);

        /**
         * <p>
         * An array of key-value pairs containing information about the ports on the instance.
         * </p>
         * 
         * @param ports
         *        An array of key-value pairs containing information about the ports on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ports(InstancePortInfo... ports);
    }

    static final class BuilderImpl implements Builder {
        private MonthlyTransfer monthlyTransfer;

        private List<InstancePortInfo> ports;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworking model) {
            monthlyTransfer(model.monthlyTransfer);
            ports(model.ports);
        }

        public final MonthlyTransfer.Builder getMonthlyTransfer() {
            return monthlyTransfer != null ? monthlyTransfer.toBuilder() : null;
        }

        @Override
        public final Builder monthlyTransfer(MonthlyTransfer monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer;
            return this;
        }

        public final void setMonthlyTransfer(MonthlyTransfer.BuilderImpl monthlyTransfer) {
            this.monthlyTransfer = monthlyTransfer != null ? monthlyTransfer.build() : null;
        }

        public final Collection<InstancePortInfo.Builder> getPorts() {
            return ports != null ? ports.stream().map(InstancePortInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ports(Collection<InstancePortInfo> ports) {
            this.ports = InstancePortInfoListCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(InstancePortInfo... ports) {
            ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<InstancePortInfo.BuilderImpl> ports) {
            this.ports = InstancePortInfoListCopier.copyFromBuilder(ports);
        }

        @Override
        public InstanceNetworking build() {
            return new InstanceNetworking(this);
        }
    }
}
