/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.OperationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Operation implements StructuredPojo, ToCopyableBuilder<Operation.Builder, Operation> {
    private final String id;

    private final String resourceName;

    private final String resourceType;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final Boolean isTerminal;

    private final String operationDetails;

    private final String operationType;

    private final String status;

    private final Instant statusChangedAt;

    private final String errorCode;

    private final String errorDetails;

    private Operation(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.isTerminal = builder.isTerminal;
        this.operationDetails = builder.operationDetails;
        this.operationType = builder.operationType;
        this.status = builder.status;
        this.statusChangedAt = builder.statusChangedAt;
        this.errorCode = builder.errorCode;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The ID of the operation.
     * </p>
     * 
     * @return The ID of the operation.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The resource name.
     * </p>
     * 
     * @return The resource name.
     */
    public String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeString}.
     * </p>
     * 
     * @return The resource type.
     * @see ResourceType
     */
    public String resourceTypeString() {
        return resourceType;
    }

    /**
     * <p>
     * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The region and Availability Zone.
     * </p>
     * 
     * @return The region and Availability Zone.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * A Boolean value indicating whether the operation is terminal.
     * </p>
     * 
     * @return A Boolean value indicating whether the operation is terminal.
     */
    public Boolean isTerminal() {
        return isTerminal;
    }

    /**
     * <p>
     * Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
     * </p>
     * 
     * @return Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
     */
    public String operationDetails() {
        return operationDetails;
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public OperationType operationType() {
        return OperationType.fromValue(operationType);
    }

    /**
     * <p>
     * The type of operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operationType}
     * will return {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationTypeString}.
     * </p>
     * 
     * @return The type of operation.
     * @see OperationType
     */
    public String operationTypeString() {
        return operationType;
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see OperationStatus
     */
    public OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusString}.
     * </p>
     * 
     * @return The status of the operation.
     * @see OperationStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     * </p>
     * 
     * @return The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
     */
    public Instant statusChangedAt() {
        return statusChangedAt;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error details.
     * </p>
     * 
     * @return The error details.
     */
    public String errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(operationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(statusChangedAt());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Operation)) {
            return false;
        }
        Operation other = (Operation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceTypeString(), other.resourceTypeString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(location(), other.location())
                && Objects.equals(isTerminal(), other.isTerminal())
                && Objects.equals(operationDetails(), other.operationDetails())
                && Objects.equals(operationTypeString(), other.operationTypeString())
                && Objects.equals(statusString(), other.statusString())
                && Objects.equals(statusChangedAt(), other.statusChangedAt()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (resourceName() != null) {
            sb.append("ResourceName: ").append(resourceName()).append(",");
        }
        if (resourceTypeString() != null) {
            sb.append("ResourceType: ").append(resourceTypeString()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        if (isTerminal() != null) {
            sb.append("IsTerminal: ").append(isTerminal()).append(",");
        }
        if (operationDetails() != null) {
            sb.append("OperationDetails: ").append(operationDetails()).append(",");
        }
        if (operationTypeString() != null) {
            sb.append("OperationType: ").append(operationTypeString()).append(",");
        }
        if (statusString() != null) {
            sb.append("Status: ").append(statusString()).append(",");
        }
        if (statusChangedAt() != null) {
            sb.append("StatusChangedAt: ").append(statusChangedAt()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (errorDetails() != null) {
            sb.append("ErrorDetails: ").append(errorDetails()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.of(clazz.cast(id()));
        case "resourceName":
            return Optional.of(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.of(clazz.cast(resourceTypeString()));
        case "createdAt":
            return Optional.of(clazz.cast(createdAt()));
        case "location":
            return Optional.of(clazz.cast(location()));
        case "isTerminal":
            return Optional.of(clazz.cast(isTerminal()));
        case "operationDetails":
            return Optional.of(clazz.cast(operationDetails()));
        case "operationType":
            return Optional.of(clazz.cast(operationTypeString()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "statusChangedAt":
            return Optional.of(clazz.cast(statusChangedAt()));
        case "errorCode":
            return Optional.of(clazz.cast(errorCode()));
        case "errorDetails":
            return Optional.of(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OperationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Operation> {
        /**
         * <p>
         * The ID of the operation.
         * </p>
         * 
         * @param id
         *        The ID of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The resource name.
         * </p>
         * 
         * @param resourceName
         *        The resource name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type.
         * </p>
         * 
         * @param resourceType
         *        The resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the operation was initialized (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The region and Availability Zone.
         * </p>
         * 
         * @param location
         *        The region and Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The region and Availability Zone.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().apply(location).build());
        }

        /**
         * <p>
         * A Boolean value indicating whether the operation is terminal.
         * </p>
         * 
         * @param isTerminal
         *        A Boolean value indicating whether the operation is terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTerminal(Boolean isTerminal);

        /**
         * <p>
         * Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
         * </p>
         * 
         * @param operationDetails
         *        Details about the operation (e.g., <code>Debian-1GB-Ohio-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationDetails(String operationDetails);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(String operationType);

        /**
         * <p>
         * The type of operation.
         * </p>
         * 
         * @param operationType
         *        The type of operation.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder operationType(OperationType operationType);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the operation.
         * </p>
         * 
         * @param status
         *        The status of the operation.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * </p>
         * 
         * @param statusChangedAt
         *        The timestamp when the status was changed (e.g., <code>1479816991.349</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusChangedAt(Instant statusChangedAt);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error details.
         * </p>
         * 
         * @param errorDetails
         *        The error details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resourceName;

        private String resourceType;

        private Instant createdAt;

        private ResourceLocation location;

        private Boolean isTerminal;

        private String operationDetails;

        private String operationType;

        private String status;

        private Instant statusChangedAt;

        private String errorCode;

        private String errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Operation model) {
            id(model.id);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
            createdAt(model.createdAt);
            location(model.location);
            isTerminal(model.isTerminal);
            operationDetails(model.operationDetails);
            operationType(model.operationType);
            status(model.status);
            statusChangedAt(model.statusChangedAt);
            errorCode(model.errorCode);
            errorDetails(model.errorDetails);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final Boolean getIsTerminal() {
            return isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        public final String getOperationDetails() {
            return operationDetails;
        }

        @Override
        public final Builder operationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
            return this;
        }

        public final void setOperationDetails(String operationDetails) {
            this.operationDetails = operationDetails;
        }

        public final String getOperationType() {
            return operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getStatusChangedAt() {
            return statusChangedAt;
        }

        @Override
        public final Builder statusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
            return this;
        }

        public final void setStatusChangedAt(Instant statusChangedAt) {
            this.statusChangedAt = statusChangedAt;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}
