/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateKeyPairResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateKeyPairResponseUnmarshaller implements Unmarshaller<CreateKeyPairResponse, JsonUnmarshallerContext> {

    public CreateKeyPairResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateKeyPairResponse.Builder createKeyPairResponseBuilder = CreateKeyPairResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createKeyPairResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("keyPair", targetDepth)) {
                    context.nextToken();
                    createKeyPairResponseBuilder.keyPair(KeyPairUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("publicKeyBase64", targetDepth)) {
                    context.nextToken();
                    createKeyPairResponseBuilder.publicKeyBase64(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("privateKeyBase64", targetDepth)) {
                    context.nextToken();
                    createKeyPairResponseBuilder.privateKeyBase64(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("operation", targetDepth)) {
                    context.nextToken();
                    createKeyPairResponseBuilder.operation(OperationUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createKeyPairResponseBuilder.build();
    }

    private static final CreateKeyPairResponseUnmarshaller INSTANCE = new CreateKeyPairResponseUnmarshaller();

    public static CreateKeyPairResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
