/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.lightsail.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MetricDatapoint JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MetricDatapointUnmarshaller implements Unmarshaller<MetricDatapoint, JsonUnmarshallerContext> {

    public MetricDatapoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        MetricDatapoint.Builder metricDatapointBuilder = MetricDatapoint.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("average", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.average(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("maximum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.maximum(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("minimum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.minimum(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("sampleCount", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.sampleCount(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("sum", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.sum(context.getUnmarshaller(Double.class).unmarshall(context));
                }
                if (context.testExpression("timestamp", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.timestamp(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("unit", targetDepth)) {
                    context.nextToken();
                    metricDatapointBuilder.unit(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return metricDatapointBuilder.build();
    }

    private static final MetricDatapointUnmarshaller INSTANCE = new MetricDatapointUnmarshaller();

    public static MetricDatapointUnmarshaller getInstance() {
        return INSTANCE;
    }
}
