/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.DiskState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.transform.DiskMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Disk
implements StructuredPojo,
ToCopyableBuilder<Builder, Disk> {
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final Integer sizeInGb;
    private final Boolean isSystemDisk;
    private final Integer iops;
    private final String path;
    private final String state;
    private final String attachedTo;
    private final Boolean isAttached;
    private final String attachmentState;
    private final Integer gbInUse;

    private Disk(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.sizeInGb = builder.sizeInGb;
        this.isSystemDisk = builder.isSystemDisk;
        this.iops = builder.iops;
        this.path = builder.path;
        this.state = builder.state;
        this.attachedTo = builder.attachedTo;
        this.isAttached = builder.isAttached;
        this.attachmentState = builder.attachmentState;
        this.gbInUse = builder.gbInUse;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String supportCode() {
        return this.supportCode;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeString() {
        return this.resourceType;
    }

    public Integer sizeInGb() {
        return this.sizeInGb;
    }

    public Boolean isSystemDisk() {
        return this.isSystemDisk;
    }

    public Integer iops() {
        return this.iops;
    }

    public String path() {
        return this.path;
    }

    public DiskState state() {
        return DiskState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String attachedTo() {
        return this.attachedTo;
    }

    public Boolean isAttached() {
        return this.isAttached;
    }

    public String attachmentState() {
        return this.attachmentState;
    }

    public Integer gbInUse() {
        return this.gbInUse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSystemDisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttached());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentState());
        hashCode = 31 * hashCode + Objects.hashCode(this.gbInUse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeString(), other.resourceTypeString()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.isSystemDisk(), other.isSystemDisk()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.attachedTo(), other.attachedTo()) && Objects.equals(this.isAttached(), other.isAttached()) && Objects.equals(this.attachmentState(), other.attachmentState()) && Objects.equals(this.gbInUse(), other.gbInUse());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.supportCode() != null) {
            sb.append("SupportCode: ").append(this.supportCode()).append(",");
        }
        if (this.createdAt() != null) {
            sb.append("CreatedAt: ").append(this.createdAt()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.resourceTypeString() != null) {
            sb.append("ResourceType: ").append(this.resourceTypeString()).append(",");
        }
        if (this.sizeInGb() != null) {
            sb.append("SizeInGb: ").append(this.sizeInGb()).append(",");
        }
        if (this.isSystemDisk() != null) {
            sb.append("IsSystemDisk: ").append(this.isSystemDisk()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.attachedTo() != null) {
            sb.append("AttachedTo: ").append(this.attachedTo()).append(",");
        }
        if (this.isAttached() != null) {
            sb.append("IsAttached: ").append(this.isAttached()).append(",");
        }
        if (this.attachmentState() != null) {
            sb.append("AttachmentState: ").append(this.attachmentState()).append(",");
        }
        if (this.gbInUse() != null) {
            sb.append("GbInUse: ").append(this.gbInUse()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.of(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.of(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.of(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.of(clazz.cast(this.resourceTypeString()));
            }
            case "sizeInGb": {
                return Optional.of(clazz.cast(this.sizeInGb()));
            }
            case "isSystemDisk": {
                return Optional.of(clazz.cast(this.isSystemDisk()));
            }
            case "iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "path": {
                return Optional.of(clazz.cast(this.path()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "attachedTo": {
                return Optional.of(clazz.cast(this.attachedTo()));
            }
            case "isAttached": {
                return Optional.of(clazz.cast(this.isAttached()));
            }
            case "attachmentState": {
                return Optional.of(clazz.cast(this.attachmentState()));
            }
            case "gbInUse": {
                return Optional.of(clazz.cast(this.gbInUse()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private Integer sizeInGb;
        private Boolean isSystemDisk;
        private Integer iops;
        private String path;
        private String state;
        private String attachedTo;
        private Boolean isAttached;
        private String attachmentState;
        private Integer gbInUse;

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.sizeInGb(model.sizeInGb);
            this.isSystemDisk(model.isSystemDisk);
            this.iops(model.iops);
            this.path(model.path);
            this.state(model.state);
            this.attachedTo(model.attachedTo);
            this.isAttached(model.isAttached);
            this.attachmentState(model.attachmentState);
            this.gbInUse(model.gbInUse);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final Boolean getIsSystemDisk() {
            return this.isSystemDisk;
        }

        @Override
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getAttachedTo() {
            return this.attachedTo;
        }

        @Override
        public final Builder attachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
            return this;
        }

        public final void setAttachedTo(String attachedTo) {
            this.attachedTo = attachedTo;
        }

        public final Boolean getIsAttached() {
            return this.isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public final String getAttachmentState() {
            return this.attachmentState;
        }

        @Override
        public final Builder attachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
            return this;
        }

        public final void setAttachmentState(String attachmentState) {
            this.attachmentState = attachmentState;
        }

        public final Integer getGbInUse() {
            return this.gbInUse;
        }

        @Override
        public final Builder gbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
            return this;
        }

        public final void setGbInUse(Integer gbInUse) {
            this.gbInUse = gbInUse;
        }

        public Disk build() {
            return new Disk(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Disk> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().apply(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder sizeInGb(Integer var1);

        public Builder isSystemDisk(Boolean var1);

        public Builder iops(Integer var1);

        public Builder path(String var1);

        public Builder state(String var1);

        public Builder state(DiskState var1);

        public Builder attachedTo(String var1);

        public Builder isAttached(Boolean var1);

        public Builder attachmentState(String var1);

        public Builder gbInUse(Integer var1);
    }
}

