/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.lightsail.model.Bundle;
import software.amazon.awssdk.services.lightsail.model.BundleListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBundlesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetBundlesResponse> {
    private final List<Bundle> bundles;
    private final String nextPageToken;

    private GetBundlesResponse(BuilderImpl builder) {
        super(builder);
        this.bundles = builder.bundles;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<Bundle> bundles() {
        return this.bundles;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundles());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesResponse)) {
            return false;
        }
        GetBundlesResponse other = (GetBundlesResponse)((Object)obj);
        return Objects.equals(this.bundles(), other.bundles()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bundles() != null) {
            sb.append("Bundles: ").append(this.bundles()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundles": {
                return Optional.of(clazz.cast(this.bundles()));
            }
            case "nextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<Bundle> bundles;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesResponse model) {
            this.bundles(model.bundles);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<Bundle.Builder> getBundles() {
            return this.bundles != null ? (Collection)this.bundles.stream().map(Bundle::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bundles(Collection<Bundle> bundles) {
            this.bundles = BundleListCopier.copy(bundles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundles(Bundle ... bundles) {
            this.bundles(Arrays.asList(bundles));
            return this;
        }

        public final void setBundles(Collection<Bundle.BuilderImpl> bundles) {
            this.bundles = BundleListCopier.copyFromBuilder(bundles);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetBundlesResponse build() {
            return new GetBundlesResponse(this);
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    CopyableBuilder<Builder, GetBundlesResponse> {
        public Builder bundles(Collection<Bundle> var1);

        public Builder bundles(Bundle ... var1);

        public Builder nextPageToken(String var1);
    }
}

