/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopInstanceRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, StopInstanceRequest> {
    private final String instanceName;
    private final Boolean force;

    private StopInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.force = builder.force;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstanceRequest)) {
            return false;
        }
        StopInstanceRequest other = (StopInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.force(), other.force());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "force": {
                return Optional.of(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstanceRequest model) {
            this.instanceName(model.instanceName);
            this.force(model.force);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StopInstanceRequest build() {
            return new StopInstanceRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, StopInstanceRequest> {
        public Builder instanceName(String var1);

        public Builder force(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

