/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.lightsail.model.Disk;
import software.amazon.awssdk.services.lightsail.transform.ResourceLocationUnmarshaller;

public class DiskUnmarshaller
implements Unmarshaller<Disk, JsonUnmarshallerContext> {
    private static final DiskUnmarshaller INSTANCE = new DiskUnmarshaller();

    public Disk unmarshall(JsonUnmarshallerContext context) throws Exception {
        Disk.Builder diskBuilder = Disk.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    diskBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    diskBuilder.arn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    diskBuilder.supportCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    diskBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    diskBuilder.location(ResourceLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    diskBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sizeInGb", targetDepth)) {
                    context.nextToken();
                    diskBuilder.sizeInGb((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("isSystemDisk", targetDepth)) {
                    context.nextToken();
                    diskBuilder.isSystemDisk((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("iops", targetDepth)) {
                    context.nextToken();
                    diskBuilder.iops((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("path", targetDepth)) {
                    context.nextToken();
                    diskBuilder.path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("state", targetDepth)) {
                    context.nextToken();
                    diskBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("attachedTo", targetDepth)) {
                    context.nextToken();
                    diskBuilder.attachedTo((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isAttached", targetDepth)) {
                    context.nextToken();
                    diskBuilder.isAttached((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("attachmentState", targetDepth)) {
                    context.nextToken();
                    diskBuilder.attachmentState((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("gbInUse", targetDepth)) {
                    context.nextToken();
                    diskBuilder.gbInUse((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Disk)diskBuilder.build();
    }

    public static DiskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

