/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AttachDiskRequest extends LightsailRequest implements
        ToCopyableBuilder<AttachDiskRequest.Builder, AttachDiskRequest> {
    private final String diskName;

    private final String instanceName;

    private final String diskPath;

    private AttachDiskRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.instanceName = builder.instanceName;
        this.diskPath = builder.diskPath;
    }

    /**
     * <p>
     * The unique Lightsail disk name (e.g., <code>my-disk</code>).
     * </p>
     * 
     * @return The unique Lightsail disk name (e.g., <code>my-disk</code>).
     */
    public String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The name of the Lightsail instance where you want to utilize the storage disk.
     * </p>
     * 
     * @return The name of the Lightsail instance where you want to utilize the storage disk.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).
     * </p>
     * 
     * @return The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).
     */
    public String diskPath() {
        return diskPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(diskPath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachDiskRequest)) {
            return false;
        }
        AttachDiskRequest other = (AttachDiskRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(instanceName(), other.instanceName())
                && Objects.equals(diskPath(), other.diskPath());
    }

    @Override
    public String toString() {
        return ToString.builder("AttachDiskRequest").add("DiskName", diskName()).add("InstanceName", instanceName())
                .add("DiskPath", diskPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.of(clazz.cast(diskName()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        case "diskPath":
            return Optional.of(clazz.cast(diskPath()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, AttachDiskRequest> {
        /**
         * <p>
         * The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique Lightsail disk name (e.g., <code>my-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The name of the Lightsail instance where you want to utilize the storage disk.
         * </p>
         * 
         * @param instanceName
         *        The name of the Lightsail instance where you want to utilize the storage disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).
         * </p>
         * 
         * @param diskPath
         *        The disk path to expose to the instance (e.g., <code>/dev/xvdf</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskPath(String diskPath);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String instanceName;

        private String diskPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachDiskRequest model) {
            diskName(model.diskName);
            instanceName(model.instanceName);
            diskPath(model.diskPath);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getDiskPath() {
            return diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AttachDiskRequest build() {
            return new AttachDiskRequest(this);
        }
    }
}
