/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CloseInstancePublicPortsRequest extends LightsailRequest implements
        ToCopyableBuilder<CloseInstancePublicPortsRequest.Builder, CloseInstancePublicPortsRequest> {
    private final PortInfo portInfo;

    private final String instanceName;

    private CloseInstancePublicPortsRequest(BuilderImpl builder) {
        super(builder);
        this.portInfo = builder.portInfo;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * Information about the public port you are trying to close.
     * </p>
     * 
     * @return Information about the public port you are trying to close.
     */
    public PortInfo portInfo() {
        return portInfo;
    }

    /**
     * <p>
     * The name of the instance on which you're attempting to close the public ports.
     * </p>
     * 
     * @return The name of the instance on which you're attempting to close the public ports.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloseInstancePublicPortsRequest)) {
            return false;
        }
        CloseInstancePublicPortsRequest other = (CloseInstancePublicPortsRequest) obj;
        return Objects.equals(portInfo(), other.portInfo()) && Objects.equals(instanceName(), other.instanceName());
    }

    @Override
    public String toString() {
        return ToString.builder("CloseInstancePublicPortsRequest").add("PortInfo", portInfo())
                .add("InstanceName", instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portInfo":
            return Optional.of(clazz.cast(portInfo()));
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, CloseInstancePublicPortsRequest> {
        /**
         * <p>
         * Information about the public port you are trying to close.
         * </p>
         * 
         * @param portInfo
         *        Information about the public port you are trying to close.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portInfo(PortInfo portInfo);

        /**
         * <p>
         * Information about the public port you are trying to close.
         * </p>
         * This is a convenience that creates an instance of the {@link PortInfo.Builder} avoiding the need to create
         * one manually via {@link PortInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #portInfo(PortInfo)}.
         * 
         * @param portInfo
         *        a consumer that will call methods on {@link PortInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portInfo(PortInfo)
         */
        default Builder portInfo(Consumer<PortInfo.Builder> portInfo) {
            return portInfo(PortInfo.builder().apply(portInfo).build());
        }

        /**
         * <p>
         * The name of the instance on which you're attempting to close the public ports.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance on which you're attempting to close the public ports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private PortInfo portInfo;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloseInstancePublicPortsRequest model) {
            portInfo(model.portInfo);
            instanceName(model.instanceName);
        }

        public final PortInfo.Builder getPortInfo() {
            return portInfo != null ? portInfo.toBuilder() : null;
        }

        @Override
        public final Builder portInfo(PortInfo portInfo) {
            this.portInfo = portInfo;
            return this;
        }

        public final void setPortInfo(PortInfo.BuilderImpl portInfo) {
            this.portInfo = portInfo != null ? portInfo.build() : null;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CloseInstancePublicPortsRequest build() {
            return new CloseInstancePublicPortsRequest(this);
        }
    }
}
