/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstancesRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateInstancesRequest.Builder, CreateInstancesRequest> {
    private final List<String> instanceNames;

    private final String availabilityZone;

    private final String customImageName;

    private final String blueprintId;

    private final String bundleId;

    private final String userData;

    private final String keyPairName;

    private CreateInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceNames = builder.instanceNames;
        this.availabilityZone = builder.availabilityZone;
        this.customImageName = builder.customImageName;
        this.blueprintId = builder.blueprintId;
        this.bundleId = builder.bundleId;
        this.userData = builder.userData;
        this.keyPairName = builder.keyPairName;
    }

    /**
     * <p>
     * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas, for
     * example: <code>["MyFirstInstance","MySecondInstance"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
     *         commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
     */
    public List<String> instanceNames() {
        return instanceNames;
    }

    /**
     * <p>
     * The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code> (case
     * sensitive). You can get a list of availability zones by using the <a
     * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     * </p>
     * 
     * @return The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code>
     *         (case sensitive). You can get a list of availability zones by using the <a
     *         href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
     *         operation. Be sure to add the <code>include availability zones</code> parameter to your request.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * (Deprecated) The name for your custom image.
     * </p>
     * <note>
     * <p>
     * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
     * </p>
     * </note>
     * 
     * @return (Deprecated) The name for your custom image.</p> <note>
     *         <p>
     *         In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
     *         </p>
     */
    public String customImageName() {
        return customImageName;
    }

    /**
     * <p>
     * The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>).
     * Use the get blueprints operation to return a list of available images (or <i>blueprints</i>).
     * </p>
     * 
     * @return The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
     *         <code>app_lamp_7_0</code>). Use the get blueprints operation to return a list of available images (or
     *         <i>blueprints</i>).
     */
    public String blueprintId() {
        return blueprintId;
    }

    /**
     * <p>
     * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
     * pricing plan (e.g., <code>micro_1_0</code>).
     * </p>
     * 
     * @return The bundle of specification information for your virtual private server (or <i>instance</i>), including
     *         the pricing plan (e.g., <code>micro_1_0</code>).
     */
    public String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * A launch script you can create that configures a server with additional user data. For example, you might want to
     * run <code>apt-get –y update</code>.
     * </p>
     * <note>
     * <p>
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and
     * CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses <code>pkg</code>. For a
     * complete list, see the <a href=
     * "https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image"
     * >Dev Guide</a>.
     * </p>
     * </note>
     * 
     * @return A launch script you can create that configures a server with additional user data. For example, you might
     *         want to run <code>apt-get –y update</code>.</p> <note>
     *         <p>
     *         Depending on the machine image you choose, the command to get software on your instance varies. Amazon
     *         Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
     *         <code>pkg</code>. For a complete list, see the <a href=
     *         "https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image"
     *         >Dev Guide</a>.
     *         </p>
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * The name of your key pair.
     * </p>
     * 
     * @return The name of your key pair.
     */
    public String keyPairName() {
        return keyPairName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceNames());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(customImageName());
        hashCode = 31 * hashCode + Objects.hashCode(blueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(keyPairName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstancesRequest)) {
            return false;
        }
        CreateInstancesRequest other = (CreateInstancesRequest) obj;
        return Objects.equals(instanceNames(), other.instanceNames())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(customImageName(), other.customImageName())
                && Objects.equals(blueprintId(), other.blueprintId()) && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(userData(), other.userData()) && Objects.equals(keyPairName(), other.keyPairName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstancesRequest").add("InstanceNames", instanceNames())
                .add("AvailabilityZone", availabilityZone()).add("CustomImageName", customImageName())
                .add("BlueprintId", blueprintId()).add("BundleId", bundleId()).add("UserData", userData())
                .add("KeyPairName", keyPairName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceNames":
            return Optional.of(clazz.cast(instanceNames()));
        case "availabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "customImageName":
            return Optional.of(clazz.cast(customImageName()));
        case "blueprintId":
            return Optional.of(clazz.cast(blueprintId()));
        case "bundleId":
            return Optional.of(clazz.cast(bundleId()));
        case "userData":
            return Optional.of(clazz.cast(userData()));
        case "keyPairName":
            return Optional.of(clazz.cast(keyPairName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, CreateInstancesRequest> {
        /**
         * <p>
         * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas,
         * for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * </p>
         * 
         * @param instanceNames
         *        The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
         *        commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(Collection<String> instanceNames);

        /**
         * <p>
         * The names to use for your new Lightsail instances. Separate multiple values using quotation marks and commas,
         * for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * </p>
         * 
         * @param instanceNames
         *        The names to use for your new Lightsail instances. Separate multiple values using quotation marks and
         *        commas, for example: <code>["MyFirstInstance","MySecondInstance"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceNames(String... instanceNames);

        /**
         * <p>
         * The Availability Zone in which to create your instance. Use the following format: <code>us-east-2a</code>
         * (case sensitive). You can get a list of availability zones by using the <a
         * href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get regions</a>
         * operation. Be sure to add the <code>include availability zones</code> parameter to your request.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create your instance. Use the following format:
         *        <code>us-east-2a</code> (case sensitive). You can get a list of availability zones by using the <a
         *        href="http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html">get
         *        regions</a> operation. Be sure to add the <code>include availability zones</code> parameter to your
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * (Deprecated) The name for your custom image.
         * </p>
         * <note>
         * <p>
         * In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
         * </p>
         * </note>
         * 
         * @param customImageName
         *        (Deprecated) The name for your custom image.</p> <note>
         *        <p>
         *        In releases prior to June 12, 2017, this parameter was ignored by the API. It is now deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customImageName(String customImageName);

        /**
         * <p>
         * The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or <code>app_lamp_7_0</code>
         * ). Use the get blueprints operation to return a list of available images (or <i>blueprints</i>).
         * </p>
         * 
         * @param blueprintId
         *        The ID for a virtual private server image (e.g., <code>app_wordpress_4_4</code> or
         *        <code>app_lamp_7_0</code>). Use the get blueprints operation to return a list of available images (or
         *        <i>blueprints</i>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprintId(String blueprintId);

        /**
         * <p>
         * The bundle of specification information for your virtual private server (or <i>instance</i>), including the
         * pricing plan (e.g., <code>micro_1_0</code>).
         * </p>
         * 
         * @param bundleId
         *        The bundle of specification information for your virtual private server (or <i>instance</i>),
         *        including the pricing plan (e.g., <code>micro_1_0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * A launch script you can create that configures a server with additional user data. For example, you might
         * want to run <code>apt-get –y update</code>.
         * </p>
         * <note>
         * <p>
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux
         * and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         * <code>pkg</code>. For a complete list, see the <a href=
         * "https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image"
         * >Dev Guide</a>.
         * </p>
         * </note>
         * 
         * @param userData
         *        A launch script you can create that configures a server with additional user data. For example, you
         *        might want to run <code>apt-get –y update</code>.</p> <note>
         *        <p>
         *        Depending on the machine image you choose, the command to get software on your instance varies. Amazon
         *        Linux and CentOS use <code>yum</code>, Debian and Ubuntu use <code>apt-get</code>, and FreeBSD uses
         *        <code>pkg</code>. For a complete list, see the <a href=
         *        "https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image"
         *        >Dev Guide</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * The name of your key pair.
         * </p>
         * 
         * @param keyPairName
         *        The name of your key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairName(String keyPairName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> instanceNames;

        private String availabilityZone;

        private String customImageName;

        private String blueprintId;

        private String bundleId;

        private String userData;

        private String keyPairName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstancesRequest model) {
            instanceNames(model.instanceNames);
            availabilityZone(model.availabilityZone);
            customImageName(model.customImageName);
            blueprintId(model.blueprintId);
            bundleId(model.bundleId);
            userData(model.userData);
            keyPairName(model.keyPairName);
        }

        public final Collection<String> getInstanceNames() {
            return instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String... instanceNames) {
            instanceNames(Arrays.asList(instanceNames));
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = StringListCopier.copy(instanceNames);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCustomImageName() {
            return customImageName;
        }

        @Override
        public final Builder customImageName(String customImageName) {
            this.customImageName = customImageName;
            return this;
        }

        public final void setCustomImageName(String customImageName) {
            this.customImageName = customImageName;
        }

        public final String getBlueprintId() {
            return blueprintId;
        }

        @Override
        public final Builder blueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public final void setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getKeyPairName() {
            return keyPairName;
        }

        @Override
        public final Builder keyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
            return this;
        }

        public final void setKeyPairName(String keyPairName) {
            this.keyPairName = keyPairName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstancesRequest build() {
            return new CreateInstancesRequest(this);
        }
    }
}
