/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetBlueprintsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBlueprintsResponse.Builder, GetBlueprintsResponse> {
    private final List<Blueprint> blueprints;

    private final String nextPageToken;

    private GetBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs that contains information about the available blueprints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs that contains information about the available blueprints.
     */
    public List<Blueprint> blueprints() {
        return blueprints;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get blueprints request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get blueprints request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueprints());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsResponse)) {
            return false;
        }
        GetBlueprintsResponse other = (GetBlueprintsResponse) obj;
        return Objects.equals(blueprints(), other.blueprints()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetBlueprintsResponse").add("Blueprints", blueprints()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprints":
            return Optional.of(clazz.cast(blueprints()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetBlueprintsResponse> {
        /**
         * <p>
         * An array of key-value pairs that contains information about the available blueprints.
         * </p>
         * 
         * @param blueprints
         *        An array of key-value pairs that contains information about the available blueprints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<Blueprint> blueprints);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available blueprints.
         * </p>
         * 
         * @param blueprints
         *        An array of key-value pairs that contains information about the available blueprints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Blueprint... blueprints);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get blueprints request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get blueprints request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Blueprint> blueprints;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsResponse model) {
            blueprints(model.blueprints);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Blueprint.Builder> getBlueprints() {
            return blueprints != null ? blueprints.stream().map(Blueprint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetBlueprintsResponse build() {
            return new GetBlueprintsResponse(this);
        }
    }
}
