/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainResponse extends LightsailResponse implements
        ToCopyableBuilder<GetDomainResponse.Builder, GetDomainResponse> {
    private final Domain domain;

    private GetDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about your get domain request.
     * </p>
     * 
     * @return An array of key-value pairs containing information about your get domain request.
     */
    public Domain domain() {
        return domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainResponse)) {
            return false;
        }
        GetDomainResponse other = (GetDomainResponse) obj;
        return Objects.equals(domain(), other.domain());
    }

    @Override
    public String toString() {
        return ToString.builder("GetDomainResponse").add("Domain", domain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domain":
            return Optional.of(clazz.cast(domain()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetDomainResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about your get domain request.
         * </p>
         * 
         * @param domain
         *        An array of key-value pairs containing information about your get domain request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(Domain domain);

        /**
         * <p>
         * An array of key-value pairs containing information about your get domain request.
         * </p>
         * This is a convenience that creates an instance of the {@link Domain.Builder} avoiding the need to create one
         * manually via {@link Domain#builder()}.
         *
         * When the {@link Consumer} completes, {@link Domain.Builder#build()} is called immediately and its result is
         * passed to {@link #domain(Domain)}.
         * 
         * @param domain
         *        a consumer that will call methods on {@link Domain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domain(Domain)
         */
        default Builder domain(Consumer<Domain.Builder> domain) {
            return domain(Domain.builder().apply(domain).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private Domain domain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainResponse model) {
            domain(model.domain);
        }

        public final Domain.Builder getDomain() {
            return domain != null ? domain.toBuilder() : null;
        }

        @Override
        public final Builder domain(Domain domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(Domain.BuilderImpl domain) {
            this.domain = domain != null ? domain.build() : null;
        }

        @Override
        public GetDomainResponse build() {
            return new GetDomainResponse(this);
        }
    }
}
