/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.InstanceStateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the virtual private server (or <i>instance</i>) status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceState implements StructuredPojo, ToCopyableBuilder<InstanceState.Builder, InstanceState> {
    private final Integer code;

    private final String name;

    private InstanceState(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * <p>
     * The status code for the instance.
     * </p>
     * 
     * @return The status code for the instance.
     */
    public Integer code() {
        return code;
    }

    /**
     * <p>
     * The state of the instance (e.g., <code>running</code> or <code>pending</code>).
     * </p>
     * 
     * @return The state of the instance (e.g., <code>running</code> or <code>pending</code>).
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceState").add("Code", code()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.of(clazz.cast(code()));
        case "name":
            return Optional.of(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceState> {
        /**
         * <p>
         * The status code for the instance.
         * </p>
         * 
         * @param code
         *        The status code for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The state of the instance (e.g., <code>running</code> or <code>pending</code>).
         * </p>
         * 
         * @param name
         *        The state of the instance (e.g., <code>running</code> or <code>pending</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Integer code;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            code(model.code);
            name(model.name);
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public InstanceState build() {
            return new InstanceState(this);
        }
    }
}
