/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDiskSnapshotRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, CreateDiskSnapshotRequest> {
    private final String diskName;
    private final String diskSnapshotName;

    private CreateDiskSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
    }

    public String diskName() {
        return this.diskName;
    }

    public String diskSnapshotName() {
        return this.diskSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSnapshotName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskSnapshotRequest)) {
            return false;
        }
        CreateDiskSnapshotRequest other = (CreateDiskSnapshotRequest)((Object)obj);
        return Objects.equals(this.diskName(), other.diskName()) && Objects.equals(this.diskSnapshotName(), other.diskSnapshotName());
    }

    public String toString() {
        return ToString.builder((String)"CreateDiskSnapshotRequest").add("DiskName", (Object)this.diskName()).add("DiskSnapshotName", (Object)this.diskSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "diskName": {
                return Optional.of(clazz.cast(this.diskName()));
            }
            case "diskSnapshotName": {
                return Optional.of(clazz.cast(this.diskSnapshotName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String diskName;
        private String diskSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskSnapshotRequest model) {
            this.diskName(model.diskName);
            this.diskSnapshotName(model.diskSnapshotName);
        }

        public final String getDiskName() {
            return this.diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getDiskSnapshotName() {
            return this.diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskSnapshotRequest build() {
            return new CreateDiskSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, CreateDiskSnapshotRequest> {
        public Builder diskName(String var1);

        public Builder diskSnapshotName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

