/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBundlesRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, GetBundlesRequest> {
    private final Boolean includeInactive;
    private final String pageToken;

    private GetBundlesRequest(BuilderImpl builder) {
        super(builder);
        this.includeInactive = builder.includeInactive;
        this.pageToken = builder.pageToken;
    }

    public Boolean includeInactive() {
        return this.includeInactive;
    }

    public String pageToken() {
        return this.pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.includeInactive());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBundlesRequest)) {
            return false;
        }
        GetBundlesRequest other = (GetBundlesRequest)((Object)obj);
        return Objects.equals(this.includeInactive(), other.includeInactive()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetBundlesRequest").add("IncludeInactive", (Object)this.includeInactive()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "includeInactive": {
                return Optional.of(clazz.cast(this.includeInactive()));
            }
            case "pageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private Boolean includeInactive;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBundlesRequest model) {
            this.includeInactive(model.includeInactive);
            this.pageToken(model.pageToken);
        }

        public final Boolean getIncludeInactive() {
            return this.includeInactive;
        }

        @Override
        public final Builder includeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public final void setIncludeInactive(Boolean includeInactive) {
            this.includeInactive = includeInactive;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetBundlesRequest build() {
            return new GetBundlesRequest(this);
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    CopyableBuilder<Builder, GetBundlesRequest> {
        public Builder includeInactive(Boolean var1);

        public Builder pageToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

