/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.CreateInstancesRequest;

@SdkInternalApi
public class CreateInstancesRequestModelMarshaller {
    private static final MarshallingInfo<List> INSTANCENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceNames").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").build();
    private static final MarshallingInfo<String> CUSTOMIMAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customImageName").build();
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").build();
    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").build();
    private static final MarshallingInfo<String> USERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userData").build();
    private static final MarshallingInfo<String> KEYPAIRNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyPairName").build();
    private static final CreateInstancesRequestModelMarshaller INSTANCE = new CreateInstancesRequestModelMarshaller();

    public static CreateInstancesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateInstancesRequest createInstancesRequest, ProtocolMarshaller protocolMarshaller) {
        if (createInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(createInstancesRequest.instanceNames(), INSTANCENAMES_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.customImageName(), CUSTOMIMAGENAME_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.userData(), USERDATA_BINDING);
            protocolMarshaller.marshall((Object)createInstancesRequest.keyPairName(), KEYPAIRNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

