/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteDiskSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<DeleteDiskSnapshotRequest.Builder, DeleteDiskSnapshotRequest> {
    private final String diskSnapshotName;

    private DeleteDiskSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskSnapshotName = builder.diskSnapshotName;
    }

    /**
     * <p>
     * The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).
     * </p>
     * 
     * @return The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).
     */
    public String diskSnapshotName() {
        return diskSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDiskSnapshotRequest)) {
            return false;
        }
        DeleteDiskSnapshotRequest other = (DeleteDiskSnapshotRequest) obj;
        return Objects.equals(diskSnapshotName(), other.diskSnapshotName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteDiskSnapshotRequest").add("DiskSnapshotName", diskSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskSnapshotName":
            return Optional.of(clazz.cast(diskSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, DeleteDiskSnapshotRequest> {
        /**
         * <p>
         * The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).
         * </p>
         * 
         * @param diskSnapshotName
         *        The name of the disk snapshot you want to delete (e.g., <code>my-disk-snapshot</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotName(String diskSnapshotName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDiskSnapshotRequest model) {
            diskSnapshotName(model.diskSnapshotName);
        }

        public final String getDiskSnapshotName() {
            return diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteDiskSnapshotRequest build() {
            return new DeleteDiskSnapshotRequest(this);
        }
    }
}
