/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstanceAccessDetailsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetInstanceAccessDetailsRequest.Builder, GetInstanceAccessDetailsRequest> {
    private final String instanceName;

    private final String protocol;

    private GetInstanceAccessDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The name of the instance to access.
     * </p>
     * 
     * @return The name of the instance to access.
     */
    public String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link InstanceAccessProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolString}.
     * </p>
     * 
     * @return The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * @see InstanceAccessProtocol
     */
    public InstanceAccessProtocol protocol() {
        return InstanceAccessProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link InstanceAccessProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolString}.
     * </p>
     * 
     * @return The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
     * @see InstanceAccessProtocol
     */
    public String protocolString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(protocolString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceAccessDetailsRequest)) {
            return false;
        }
        GetInstanceAccessDetailsRequest other = (GetInstanceAccessDetailsRequest) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(protocolString(), other.protocolString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetInstanceAccessDetailsRequest").add("InstanceName", instanceName())
                .add("Protocol", protocolString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.of(clazz.cast(instanceName()));
        case "protocol":
            return Optional.of(clazz.cast(protocolString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, GetInstanceAccessDetailsRequest> {
        /**
         * <p>
         * The name of the instance to access.
         * </p>
         * 
         * @param instanceName
         *        The name of the instance to access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol to use to connect to your instance. Defaults to <code>ssh</code>.
         * @see InstanceAccessProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceAccessProtocol
         */
        Builder protocol(InstanceAccessProtocol protocol);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceName;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceAccessDetailsRequest model) {
            instanceName(model.instanceName);
            protocol(model.protocol);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(InstanceAccessProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetInstanceAccessDetailsRequest build() {
            return new GetInstanceAccessDetailsRequest(this);
        }
    }
}
