/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetKeyPairsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetKeyPairsResponse.Builder, GetKeyPairsResponse> {
    private final List<KeyPair> keyPairs;

    private final String nextPageToken;

    private GetKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the key pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the key pairs.
     */
    public List<KeyPair> keyPairs() {
        return keyPairs;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get key pairs request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get key pairs request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyPairs());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyPairsResponse)) {
            return false;
        }
        GetKeyPairsResponse other = (GetKeyPairsResponse) obj;
        return Objects.equals(keyPairs(), other.keyPairs()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetKeyPairsResponse").add("KeyPairs", keyPairs()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "keyPairs":
            return Optional.of(clazz.cast(keyPairs()));
        case "nextPageToken":
            return Optional.of(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetKeyPairsResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(Collection<KeyPair> keyPairs);

        /**
         * <p>
         * An array of key-value pairs containing information about the key pairs.
         * </p>
         * 
         * @param keyPairs
         *        An array of key-value pairs containing information about the key pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPairs(KeyPair... keyPairs);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get key pairs request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get key pairs request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<KeyPair> keyPairs;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyPairsResponse model) {
            keyPairs(model.keyPairs);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<KeyPair.Builder> getKeyPairs() {
            return keyPairs != null ? keyPairs.stream().map(KeyPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPair> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPair... keyPairs) {
            keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPair.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetKeyPairsResponse build() {
            return new GetKeyPairsResponse(this);
        }
    }
}
