/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRegionsRequest extends LightsailRequest implements
        ToCopyableBuilder<GetRegionsRequest.Builder, GetRegionsRequest> {
    private final Boolean includeAvailabilityZones;

    private GetRegionsRequest(BuilderImpl builder) {
        super(builder);
        this.includeAvailabilityZones = builder.includeAvailabilityZones;
    }

    /**
     * <p>
     * A Boolean value indicating whether to also include Availability Zones in your get regions request. Availability
     * Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
     * </p>
     * 
     * @return A Boolean value indicating whether to also include Availability Zones in your get regions request.
     *         Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
     */
    public Boolean includeAvailabilityZones() {
        return includeAvailabilityZones;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeAvailabilityZones());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRegionsRequest)) {
            return false;
        }
        GetRegionsRequest other = (GetRegionsRequest) obj;
        return Objects.equals(includeAvailabilityZones(), other.includeAvailabilityZones());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRegionsRequest").add("IncludeAvailabilityZones", includeAvailabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeAvailabilityZones":
            return Optional.of(clazz.cast(includeAvailabilityZones()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailRequest.Builder, CopyableBuilder<Builder, GetRegionsRequest> {
        /**
         * <p>
         * A Boolean value indicating whether to also include Availability Zones in your get regions request.
         * Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
         * </p>
         * 
         * @param includeAvailabilityZones
         *        A Boolean value indicating whether to also include Availability Zones in your get regions request.
         *        Availability Zones are indicated with a letter: e.g., <code>us-east-2a</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAvailabilityZones(Boolean includeAvailabilityZones);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private Boolean includeAvailabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRegionsRequest model) {
            includeAvailabilityZones(model.includeAvailabilityZones);
        }

        public final Boolean getIncludeAvailabilityZones() {
            return includeAvailabilityZones;
        }

        @Override
        public final Builder includeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
            return this;
        }

        public final void setIncludeAvailabilityZones(Boolean includeAvailabilityZones) {
            this.includeAvailabilityZones = includeAvailabilityZones;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetRegionsRequest build() {
            return new GetRegionsRequest(this);
        }
    }
}
