/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetStaticIpResponse extends LightsailResponse implements
        ToCopyableBuilder<GetStaticIpResponse.Builder, GetStaticIpResponse> {
    private final StaticIp staticIp;

    private GetStaticIpResponse(BuilderImpl builder) {
        super(builder);
        this.staticIp = builder.staticIp;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the requested static IP.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the requested static IP.
     */
    public StaticIp staticIp() {
        return staticIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStaticIpResponse)) {
            return false;
        }
        GetStaticIpResponse other = (GetStaticIpResponse) obj;
        return Objects.equals(staticIp(), other.staticIp());
    }

    @Override
    public String toString() {
        return ToString.builder("GetStaticIpResponse").add("StaticIp", staticIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "staticIp":
            return Optional.of(clazz.cast(staticIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends LightsailResponse.Builder, CopyableBuilder<Builder, GetStaticIpResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the requested static IP.
         * </p>
         * 
         * @param staticIp
         *        An array of key-value pairs containing information about the requested static IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticIp(StaticIp staticIp);

        /**
         * <p>
         * An array of key-value pairs containing information about the requested static IP.
         * </p>
         * This is a convenience that creates an instance of the {@link StaticIp.Builder} avoiding the need to create
         * one manually via {@link StaticIp#builder()}.
         *
         * When the {@link Consumer} completes, {@link StaticIp.Builder#build()} is called immediately and its result is
         * passed to {@link #staticIp(StaticIp)}.
         * 
         * @param staticIp
         *        a consumer that will call methods on {@link StaticIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticIp(StaticIp)
         */
        default Builder staticIp(Consumer<StaticIp.Builder> staticIp) {
            return staticIp(StaticIp.builder().apply(staticIp).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private StaticIp staticIp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStaticIpResponse model) {
            staticIp(model.staticIp);
        }

        public final StaticIp.Builder getStaticIp() {
            return staticIp != null ? staticIp.toBuilder() : null;
        }

        @Override
        public final Builder staticIp(StaticIp staticIp) {
            this.staticIp = staticIp;
            return this;
        }

        public final void setStaticIp(StaticIp.BuilderImpl staticIp) {
            this.staticIp = staticIp != null ? staticIp.build() : null;
        }

        @Override
        public GetStaticIpResponse build() {
            return new GetStaticIpResponse(this);
        }
    }
}
