/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lightsail throws this exception when an operation fails to execute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class OperationFailureException extends LightsailException implements
        ToCopyableBuilder<OperationFailureException.Builder, OperationFailureException> {
    private final String code;

    private final String docs;

    private final String tip;

    private OperationFailureException(BuilderImpl builder) {
        super(builder.message);
        this.code = builder.code;
        this.docs = builder.docs;
        this.tip = builder.tip;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public String code() {
        return code;
    }

    /**
     * Returns the value of the Docs property for this object.
     * 
     * @return The value of the Docs property for this object.
     */
    public String docs() {
        return docs;
    }

    /**
     * Returns the value of the Tip property for this object.
     * 
     * @return The value of the Tip property for this object.
     */
    public String tip() {
        return tip;
    }

    public interface Builder extends CopyableBuilder<Builder, OperationFailureException> {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * Sets the value of the Docs property for this object.
         *
         * @param docs
         *        The new value for the Docs property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docs(String docs);

        /**
         * Sets the value of the Tip property for this object.
         *
         * @param tip
         *        The new value for the Tip property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tip(String tip);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String docs;

        private String tip;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationFailureException model) {
            code(model.code);
            docs(model.docs);
            tip(model.tip);
            this.message = model.getMessage();
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @JsonProperty("code")
        public final void setCode(String code) {
            this.code = code;
        }

        public final String getDocs() {
            return docs;
        }

        @Override
        public final Builder docs(String docs) {
            this.docs = docs;
            return this;
        }

        @JsonProperty("docs")
        public final void setDocs(String docs) {
            this.docs = docs;
        }

        public final String getTip() {
            return tip;
        }

        @Override
        public final Builder tip(String tip) {
            this.tip = tip;
            return this;
        }

        @JsonProperty("tip")
        public final void setTip(String tip) {
            this.tip = tip;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public OperationFailureException build() {
            return new OperationFailureException(this);
        }
    }
}
