/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Blueprint;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Blueprint} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BlueprintMarshaller {
    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> GROUP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("group").isBinary(false).build();

    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ISACTIVE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isActive").isBinary(false).build();

    private static final MarshallingInfo<Integer> MINPOWER_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minPower").isBinary(false).build();

    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").isBinary(false).build();

    private static final MarshallingInfo<String> VERSIONCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionCode").isBinary(false).build();

    private static final MarshallingInfo<String> PRODUCTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("productUrl").isBinary(false).build();

    private static final MarshallingInfo<String> LICENSEURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseUrl").isBinary(false).build();

    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("platform").isBinary(false).build();

    private static final BlueprintMarshaller INSTANCE = new BlueprintMarshaller();

    private BlueprintMarshaller() {
    }

    public static BlueprintMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Blueprint blueprint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(blueprint, "blueprint");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(blueprint.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall(blueprint.name(), NAME_BINDING);
            protocolMarshaller.marshall(blueprint.group(), GROUP_BINDING);
            protocolMarshaller.marshall(blueprint.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall(blueprint.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(blueprint.isActive(), ISACTIVE_BINDING);
            protocolMarshaller.marshall(blueprint.minPower(), MINPOWER_BINDING);
            protocolMarshaller.marshall(blueprint.version(), VERSION_BINDING);
            protocolMarshaller.marshall(blueprint.versionCode(), VERSIONCODE_BINDING);
            protocolMarshaller.marshall(blueprint.productUrl(), PRODUCTURL_BINDING);
            protocolMarshaller.marshall(blueprint.licenseUrl(), LICENSEURL_BINDING);
            protocolMarshaller.marshall(blueprint.platformString(), PLATFORM_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
