/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.DiskSnapshot;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link DiskSnapshot} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class DiskSnapshotMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<Integer> SIZEINGB_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sizeInGb").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();

    private static final MarshallingInfo<String> PROGRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("progress").isBinary(false).build();

    private static final MarshallingInfo<String> FROMDISKNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskName").isBinary(false).build();

    private static final MarshallingInfo<String> FROMDISKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromDiskArn").isBinary(false).build();

    private static final DiskSnapshotMarshaller INSTANCE = new DiskSnapshotMarshaller();

    private DiskSnapshotMarshaller() {
    }

    public static DiskSnapshotMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(DiskSnapshot diskSnapshot, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(diskSnapshot, "diskSnapshot");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(diskSnapshot.name(), NAME_BINDING);
            protocolMarshaller.marshall(diskSnapshot.arn(), ARN_BINDING);
            protocolMarshaller.marshall(diskSnapshot.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(diskSnapshot.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(diskSnapshot.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(diskSnapshot.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(diskSnapshot.sizeInGb(), SIZEINGB_BINDING);
            protocolMarshaller.marshall(diskSnapshot.stateString(), STATE_BINDING);
            protocolMarshaller.marshall(diskSnapshot.progress(), PROGRESS_BINDING);
            protocolMarshaller.marshall(diskSnapshot.fromDiskName(), FROMDISKNAME_BINDING);
            protocolMarshaller.marshall(diskSnapshot.fromDiskArn(), FROMDISKARN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
