/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.GetInstanceMetricDataRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link GetInstanceMetricDataRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class GetInstanceMetricDataRequestModelMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();

    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metricName").isBinary(false).build();

    private static final MarshallingInfo<Integer> PERIOD_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("period").isBinary(false).build();

    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();

    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();

    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("unit").isBinary(false).build();

    private static final MarshallingInfo<List> STATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statistics").isBinary(false).build();

    private static final GetInstanceMetricDataRequestModelMarshaller INSTANCE = new GetInstanceMetricDataRequestModelMarshaller();

    private GetInstanceMetricDataRequestModelMarshaller() {
    }

    public static GetInstanceMetricDataRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(GetInstanceMetricDataRequest getInstanceMetricDataRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(getInstanceMetricDataRequest, "getInstanceMetricDataRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(getInstanceMetricDataRequest.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.metricNameString(), METRICNAME_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.period(), PERIOD_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.unitString(), UNIT_BINDING);
            protocolMarshaller.marshall(getInstanceMetricDataRequest.statisticsStrings(), STATISTICS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
