/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.model.Instance;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Instance} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InstanceMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();

    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> SUPPORTCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportCode").isBinary(false).build();

    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> LOCATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").isBinary(false).build();

    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resourceType").isBinary(false).build();

    private static final MarshallingInfo<String> BLUEPRINTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintId").isBinary(false).build();

    private static final MarshallingInfo<String> BLUEPRINTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blueprintName").isBinary(false).build();

    private static final MarshallingInfo<String> BUNDLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bundleId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ISSTATICIP_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isStaticIp").isBinary(false).build();

    private static final MarshallingInfo<String> PRIVATEIPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privateIpAddress").isBinary(false).build();

    private static final MarshallingInfo<String> PUBLICIPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicIpAddress").isBinary(false).build();

    private static final MarshallingInfo<String> IPV6ADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipv6Address").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> HARDWARE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hardware").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> NETWORKING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("networking").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();

    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();

    private static final MarshallingInfo<String> SSHKEYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sshKeyName").isBinary(false).build();

    private static final InstanceMarshaller INSTANCE = new InstanceMarshaller();

    private InstanceMarshaller() {
    }

    public static InstanceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Instance instance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(instance, "instance");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(instance.name(), NAME_BINDING);
            protocolMarshaller.marshall(instance.arn(), ARN_BINDING);
            protocolMarshaller.marshall(instance.supportCode(), SUPPORTCODE_BINDING);
            protocolMarshaller.marshall(instance.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(instance.location(), LOCATION_BINDING);
            protocolMarshaller.marshall(instance.resourceTypeString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(instance.blueprintId(), BLUEPRINTID_BINDING);
            protocolMarshaller.marshall(instance.blueprintName(), BLUEPRINTNAME_BINDING);
            protocolMarshaller.marshall(instance.bundleId(), BUNDLEID_BINDING);
            protocolMarshaller.marshall(instance.isStaticIp(), ISSTATICIP_BINDING);
            protocolMarshaller.marshall(instance.privateIpAddress(), PRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall(instance.publicIpAddress(), PUBLICIPADDRESS_BINDING);
            protocolMarshaller.marshall(instance.ipv6Address(), IPV6ADDRESS_BINDING);
            protocolMarshaller.marshall(instance.hardware(), HARDWARE_BINDING);
            protocolMarshaller.marshall(instance.networking(), NETWORKING_BINDING);
            protocolMarshaller.marshall(instance.state(), STATE_BINDING);
            protocolMarshaller.marshall(instance.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(instance.sshKeyName(), SSHKEYNAME_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
