/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.lightsail.transform.AvailabilityZoneMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AvailabilityZone
implements StructuredPojo,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private final String zoneName;
    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.state = builder.state;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.zoneName(), other.zoneName()) && Objects.equals(this.state(), other.state());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("ZoneName", (Object)this.zoneName()).add("State", (Object)this.state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "zoneName": {
                return Optional.of(clazz.cast(this.zoneName()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AvailabilityZoneMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String zoneName;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.zoneName(model.zoneName);
            this.state(model.state);
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AvailabilityZone> {
        public Builder zoneName(String var1);

        public Builder state(String var1);
    }
}

