/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.Region;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegionMarshaller {
    private static final MarshallingInfo<String> CONTINENTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("continentCode").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZones").isBinary(false).build();
    private static final RegionMarshaller INSTANCE = new RegionMarshaller();

    private RegionMarshaller() {
    }

    public static RegionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Region region, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)region, (String)"region");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)region.continentCode(), CONTINENTCODE_BINDING);
            protocolMarshaller.marshall((Object)region.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)region.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)region.nameString(), NAME_BINDING);
            protocolMarshaller.marshall(region.availabilityZones(), AVAILABILITYZONES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

