/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceLocationMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("availabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> REGIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("regionName").isBinary(false).build();
    private static final ResourceLocationMarshaller INSTANCE = new ResourceLocationMarshaller();

    private ResourceLocationMarshaller() {
    }

    public static ResourceLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceLocation resourceLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceLocation, (String)"resourceLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceLocation.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)resourceLocation.regionNameString(), REGIONNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

