/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDiskSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateDiskSnapshotRequest.Builder, CreateDiskSnapshotRequest> {
    private static final SdkField<String> DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDiskSnapshotRequest::diskName)).setter(setter(Builder::diskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskName").build()).build();

    private static final SdkField<String> DISK_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDiskSnapshotRequest::diskSnapshotName)).setter(setter(Builder::diskSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSnapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_NAME_FIELD,
            DISK_SNAPSHOT_NAME_FIELD));

    private final String diskName;

    private final String diskSnapshotName;

    private CreateDiskSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.diskName = builder.diskName;
        this.diskSnapshotName = builder.diskSnapshotName;
    }

    /**
     * <p>
     * The unique name of the source disk (e.g., <code>my-source-disk</code>).
     * </p>
     * 
     * @return The unique name of the source disk (e.g., <code>my-source-disk</code>).
     */
    public String diskName() {
        return diskName;
    }

    /**
     * <p>
     * The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source disk.
     * </p>
     * 
     * @return The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source disk.
     */
    public String diskSnapshotName() {
        return diskSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(diskName());
        hashCode = 31 * hashCode + Objects.hashCode(diskSnapshotName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDiskSnapshotRequest)) {
            return false;
        }
        CreateDiskSnapshotRequest other = (CreateDiskSnapshotRequest) obj;
        return Objects.equals(diskName(), other.diskName()) && Objects.equals(diskSnapshotName(), other.diskSnapshotName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDiskSnapshotRequest").add("DiskName", diskName())
                .add("DiskSnapshotName", diskSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "diskName":
            return Optional.ofNullable(clazz.cast(diskName()));
        case "diskSnapshotName":
            return Optional.ofNullable(clazz.cast(diskSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDiskSnapshotRequest, T> g) {
        return obj -> g.apply((CreateDiskSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDiskSnapshotRequest> {
        /**
         * <p>
         * The unique name of the source disk (e.g., <code>my-source-disk</code>).
         * </p>
         * 
         * @param diskName
         *        The unique name of the source disk (e.g., <code>my-source-disk</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskName(String diskName);

        /**
         * <p>
         * The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source disk.
         * </p>
         * 
         * @param diskSnapshotName
         *        The name of the destination disk snapshot (e.g., <code>my-disk-snapshot</code>) based on the source
         *        disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskSnapshotName(String diskSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String diskName;

        private String diskSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDiskSnapshotRequest model) {
            super(model);
            diskName(model.diskName);
            diskSnapshotName(model.diskSnapshotName);
        }

        public final String getDiskName() {
            return diskName;
        }

        @Override
        public final Builder diskName(String diskName) {
            this.diskName = diskName;
            return this;
        }

        public final void setDiskName(String diskName) {
            this.diskName = diskName;
        }

        public final String getDiskSnapshotName() {
            return diskSnapshotName;
        }

        @Override
        public final Builder diskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
            return this;
        }

        public final void setDiskSnapshotName(String diskSnapshotName) {
            this.diskSnapshotName = diskSnapshotName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDiskSnapshotRequest build() {
            return new CreateDiskSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
