/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateInstanceSnapshotRequest.Builder, CreateInstanceSnapshotRequest> {
    private static final SdkField<String> INSTANCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInstanceSnapshotRequest::instanceSnapshotName)).setter(setter(Builder::instanceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSnapshotName").build())
            .build();

    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateInstanceSnapshotRequest::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SNAPSHOT_NAME_FIELD,
            INSTANCE_NAME_FIELD));

    private final String instanceSnapshotName;

    private final String instanceName;

    private CreateInstanceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceSnapshotName = builder.instanceSnapshotName;
        this.instanceName = builder.instanceName;
    }

    /**
     * <p>
     * The name for your new snapshot.
     * </p>
     * 
     * @return The name for your new snapshot.
     */
    public String instanceSnapshotName() {
        return instanceSnapshotName;
    }

    /**
     * <p>
     * The Lightsail instance on which to base your snapshot.
     * </p>
     * 
     * @return The Lightsail instance on which to base your snapshot.
     */
    public String instanceName() {
        return instanceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceSnapshotRequest)) {
            return false;
        }
        CreateInstanceSnapshotRequest other = (CreateInstanceSnapshotRequest) obj;
        return Objects.equals(instanceSnapshotName(), other.instanceSnapshotName())
                && Objects.equals(instanceName(), other.instanceName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstanceSnapshotRequest").add("InstanceSnapshotName", instanceSnapshotName())
                .add("InstanceName", instanceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceSnapshotName":
            return Optional.ofNullable(clazz.cast(instanceSnapshotName()));
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceSnapshotRequest, T> g) {
        return obj -> g.apply((CreateInstanceSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstanceSnapshotRequest> {
        /**
         * <p>
         * The name for your new snapshot.
         * </p>
         * 
         * @param instanceSnapshotName
         *        The name for your new snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceSnapshotName(String instanceSnapshotName);

        /**
         * <p>
         * The Lightsail instance on which to base your snapshot.
         * </p>
         * 
         * @param instanceName
         *        The Lightsail instance on which to base your snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String instanceSnapshotName;

        private String instanceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceSnapshotRequest model) {
            super(model);
            instanceSnapshotName(model.instanceSnapshotName);
            instanceName(model.instanceName);
        }

        public final String getInstanceSnapshotName() {
            return instanceSnapshotName;
        }

        @Override
        public final Builder instanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
            return this;
        }

        public final void setInstanceSnapshotName(String instanceSnapshotName) {
            this.instanceSnapshotName = instanceSnapshotName;
        }

        public final String getInstanceName() {
            return instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceSnapshotRequest build() {
            return new CreateInstanceSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
