/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRelationalDatabaseSnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CreateRelationalDatabaseSnapshotRequest.Builder, CreateRelationalDatabaseSnapshotRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseSnapshotRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRelationalDatabaseSnapshotRequest::relationalDatabaseSnapshotName))
            .setter(setter(Builder::relationalDatabaseSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshotName")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, RELATIONAL_DATABASE_SNAPSHOT_NAME_FIELD));

    private final String relationalDatabaseName;

    private final String relationalDatabaseSnapshotName;

    private CreateRelationalDatabaseSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.relationalDatabaseSnapshotName = builder.relationalDatabaseSnapshotName;
    }

    /**
     * <p>
     * The name of the database on which to base your new snapshot.
     * </p>
     * 
     * @return The name of the database on which to base your new snapshot.
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The name for your new database snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 2 to 255 alphanumeric characters, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first and last character must be a letter or number.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name for your new database snapshot.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 2 to 255 alphanumeric characters, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first and last character must be a letter or number.
     *         </p>
     *         </li>
     */
    public String relationalDatabaseSnapshotName() {
        return relationalDatabaseSnapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseSnapshotName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRelationalDatabaseSnapshotRequest)) {
            return false;
        }
        CreateRelationalDatabaseSnapshotRequest other = (CreateRelationalDatabaseSnapshotRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(relationalDatabaseSnapshotName(), other.relationalDatabaseSnapshotName());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateRelationalDatabaseSnapshotRequest")
                .add("RelationalDatabaseName", relationalDatabaseName())
                .add("RelationalDatabaseSnapshotName", relationalDatabaseSnapshotName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "relationalDatabaseSnapshotName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseSnapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRelationalDatabaseSnapshotRequest, T> g) {
        return obj -> g.apply((CreateRelationalDatabaseSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateRelationalDatabaseSnapshotRequest> {
        /**
         * <p>
         * The name of the database on which to base your new snapshot.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of the database on which to base your new snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The name for your new database snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 2 to 255 alphanumeric characters, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first and last character must be a letter or number.
         * </p>
         * </li>
         * </ul>
         * 
         * @param relationalDatabaseSnapshotName
         *        The name for your new database snapshot.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 2 to 255 alphanumeric characters, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first and last character must be a letter or number.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String relationalDatabaseSnapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRelationalDatabaseSnapshotRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            relationalDatabaseSnapshotName(model.relationalDatabaseSnapshotName);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getRelationalDatabaseSnapshotName() {
            return relationalDatabaseSnapshotName;
        }

        @Override
        public final Builder relationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
            return this;
        }

        public final void setRelationalDatabaseSnapshotName(String relationalDatabaseSnapshotName) {
            this.relationalDatabaseSnapshotName = relationalDatabaseSnapshotName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRelationalDatabaseSnapshotRequest build() {
            return new CreateRelationalDatabaseSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
