/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRelationalDatabaseRequest extends LightsailRequest implements
        ToCopyableBuilder<UpdateRelationalDatabaseRequest.Builder, UpdateRelationalDatabaseRequest> {
    private static final SdkField<String> RELATIONAL_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRelationalDatabaseRequest::relationalDatabaseName))
            .setter(setter(Builder::relationalDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseName").build())
            .build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRelationalDatabaseRequest::masterUserPassword)).setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build())
            .build();

    private static final SdkField<Boolean> ROTATE_MASTER_USER_PASSWORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(UpdateRelationalDatabaseRequest::rotateMasterUserPassword))
            .setter(setter(Builder::rotateMasterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotateMasterUserPassword").build())
            .build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRelationalDatabaseRequest::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredBackupWindow").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateRelationalDatabaseRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BACKUP_RETENTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateRelationalDatabaseRequest::enableBackupRetention))
            .setter(setter(Builder::enableBackupRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBackupRetention").build())
            .build();

    private static final SdkField<Boolean> DISABLE_BACKUP_RETENTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateRelationalDatabaseRequest::disableBackupRetention))
            .setter(setter(Builder::disableBackupRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableBackupRetention").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateRelationalDatabaseRequest::publiclyAccessible)).setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateRelationalDatabaseRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyImmediately").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RELATIONAL_DATABASE_NAME_FIELD, MASTER_USER_PASSWORD_FIELD, ROTATE_MASTER_USER_PASSWORD_FIELD,
            PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, ENABLE_BACKUP_RETENTION_FIELD,
            DISABLE_BACKUP_RETENTION_FIELD, PUBLICLY_ACCESSIBLE_FIELD, APPLY_IMMEDIATELY_FIELD));

    private final String relationalDatabaseName;

    private final String masterUserPassword;

    private final Boolean rotateMasterUserPassword;

    private final String preferredBackupWindow;

    private final String preferredMaintenanceWindow;

    private final Boolean enableBackupRetention;

    private final Boolean disableBackupRetention;

    private final Boolean publiclyAccessible;

    private final Boolean applyImmediately;

    private UpdateRelationalDatabaseRequest(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseName = builder.relationalDatabaseName;
        this.masterUserPassword = builder.masterUserPassword;
        this.rotateMasterUserPassword = builder.rotateMasterUserPassword;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.enableBackupRetention = builder.enableBackupRetention;
        this.disableBackupRetention = builder.disableBackupRetention;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.applyImmediately = builder.applyImmediately;
    }

    /**
     * <p>
     * The name of your database to update.
     * </p>
     * 
     * @return The name of your database to update.
     */
    public String relationalDatabaseName() {
        return relationalDatabaseName;
    }

    /**
     * <p>
     * The password for the master user of your database. The password can include any printable ASCII character except
     * "/", """, or "@".
     * </p>
     * <p>
     * Constraints: Must contain 8 to 41 characters.
     * </p>
     * 
     * @return The password for the master user of your database. The password can include any printable ASCII character
     *         except "/", """, or "@".</p>
     *         <p>
     *         Constraints: Must contain 8 to 41 characters.
     */
    public String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
     * </p>
     * <p>
     * Use the <code>get relational database master user password</code> operation to get the new password.
     * </p>
     * 
     * @return When <code>true</code>, the master user password is changed to a new strong password generated by
     *         Lightsail.</p>
     *         <p>
     *         Use the <code>get relational database master user password</code> operation to get the new password.
     */
    public Boolean rotateMasterUserPassword() {
        return rotateMasterUserPassword;
    }

    /**
     * <p>
     * The daily time range during which automated backups are created for your database if automated backups are
     * enabled.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>hh24:mi-hh24:mi</code> format.
     * </p>
     * <p>
     * Example: <code>16:00-16:30</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not conflict with the preferred maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The daily time range during which automated backups are created for your database if automated backups
     *         are enabled.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>hh24:mi-hh24:mi</code> format.
     *         </p>
     *         <p>
     *         Example: <code>16:00-16:30</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not conflict with the preferred maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     */
    public String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur on your database.
     * </p>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring
     * on a random day of the week.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must be at least 30 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specified in Universal Coordinated Time (UTC).
     * </p>
     * </li>
     * <li>
     * <p>
     * Example: <code>Tue:17:00-Tue:17:30</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The weekly time range during which system maintenance can occur on your database.</p>
     *         <p>
     *         The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
     *         occurring on a random day of the week.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must be at least 30 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specified in Universal Coordinated Time (UTC).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Example: <code>Tue:17:00-Tue:17:30</code>
     *         </p>
     *         </li>
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * When <code>true</code>, enables automated backup retention for your database.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, enables automated backup retention for your database.</p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */
    public Boolean enableBackupRetention() {
        return enableBackupRetention;
    }

    /**
     * <p>
     * When <code>true</code>, disables automated backup retention for your database.
     * </p>
     * <p>
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create
     * a snapshot of your database using the <code>create relational database snapshot</code> operation.
     * </p>
     * <p>
     * Updates are applied during the next maintenance window because this can result in an outage.
     * </p>
     * 
     * @return When <code>true</code>, disables automated backup retention for your database.</p>
     *         <p>
     *         Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
     *         create a snapshot of your database using the <code>create relational database snapshot</code> operation.
     *         </p>
     *         <p>
     *         Updates are applied during the next maintenance window because this can result in an outage.
     */
    public Boolean disableBackupRetention() {
        return disableBackupRetention;
    }

    /**
     * <p>
     * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that is
     * available to resources outside of your Lightsail account. A value of <code>false</code> specifies a database that
     * is available only to your Lightsail resources in the same region as your database.
     * </p>
     * 
     * @return Specifies the accessibility options for your database. A value of <code>true</code> specifies a database
     *         that is available to resources outside of your Lightsail account. A value of <code>false</code> specifies
     *         a database that is available only to your Lightsail resources in the same region as your database.
     */
    public Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     * preferred maintenance window. Some changes may cause an outage.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
     *         preferred maintenance window. Some changes may cause an outage.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(rotateMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(enableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(disableBackupRetention());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRelationalDatabaseRequest)) {
            return false;
        }
        UpdateRelationalDatabaseRequest other = (UpdateRelationalDatabaseRequest) obj;
        return Objects.equals(relationalDatabaseName(), other.relationalDatabaseName())
                && Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(rotateMasterUserPassword(), other.rotateMasterUserPassword())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(enableBackupRetention(), other.enableBackupRetention())
                && Objects.equals(disableBackupRetention(), other.disableBackupRetention())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(applyImmediately(), other.applyImmediately());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateRelationalDatabaseRequest").add("RelationalDatabaseName", relationalDatabaseName())
                .add("MasterUserPassword", masterUserPassword()).add("RotateMasterUserPassword", rotateMasterUserPassword())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("EnableBackupRetention", enableBackupRetention()).add("DisableBackupRetention", disableBackupRetention())
                .add("PubliclyAccessible", publiclyAccessible()).add("ApplyImmediately", applyImmediately()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabaseName":
            return Optional.ofNullable(clazz.cast(relationalDatabaseName()));
        case "masterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "rotateMasterUserPassword":
            return Optional.ofNullable(clazz.cast(rotateMasterUserPassword()));
        case "preferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "preferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "enableBackupRetention":
            return Optional.ofNullable(clazz.cast(enableBackupRetention()));
        case "disableBackupRetention":
            return Optional.ofNullable(clazz.cast(disableBackupRetention()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "applyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRelationalDatabaseRequest, T> g) {
        return obj -> g.apply((UpdateRelationalDatabaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRelationalDatabaseRequest> {
        /**
         * <p>
         * The name of your database to update.
         * </p>
         * 
         * @param relationalDatabaseName
         *        The name of your database to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabaseName(String relationalDatabaseName);

        /**
         * <p>
         * The password for the master user of your database. The password can include any printable ASCII character
         * except "/", """, or "@".
         * </p>
         * <p>
         * Constraints: Must contain 8 to 41 characters.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user of your database. The password can include any printable ASCII
         *        character except "/", """, or "@".</p>
         *        <p>
         *        Constraints: Must contain 8 to 41 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * When <code>true</code>, the master user password is changed to a new strong password generated by Lightsail.
         * </p>
         * <p>
         * Use the <code>get relational database master user password</code> operation to get the new password.
         * </p>
         * 
         * @param rotateMasterUserPassword
         *        When <code>true</code>, the master user password is changed to a new strong password generated by
         *        Lightsail.</p>
         *        <p>
         *        Use the <code>get relational database master user password</code> operation to get the new password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword);

        /**
         * <p>
         * The daily time range during which automated backups are created for your database if automated backups are
         * enabled.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>hh24:mi-hh24:mi</code> format.
         * </p>
         * <p>
         * Example: <code>16:00-16:30</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not conflict with the preferred maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredBackupWindow
         *        The daily time range during which automated backups are created for your database if automated backups
         *        are enabled.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>hh24:mi-hh24:mi</code> format.
         *        </p>
         *        <p>
         *        Example: <code>16:00-16:30</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not conflict with the preferred maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The weekly time range during which system maintenance can occur on your database.
         * </p>
         * <p>
         * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         * occurring on a random day of the week.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must be at least 30 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * Specified in Universal Coordinated Time (UTC).
         * </p>
         * </li>
         * <li>
         * <p>
         * Example: <code>Tue:17:00-Tue:17:30</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur on your database.</p>
         *        <p>
         *        The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region,
         *        occurring on a random day of the week.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must be in the <code>ddd:hh24:mi-ddd:hh24:mi</code> format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must be at least 30 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Specified in Universal Coordinated Time (UTC).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Example: <code>Tue:17:00-Tue:17:30</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * When <code>true</code>, enables automated backup retention for your database.
         * </p>
         * <p>
         * Updates are applied during the next maintenance window because this can result in an outage.
         * </p>
         * 
         * @param enableBackupRetention
         *        When <code>true</code>, enables automated backup retention for your database.</p>
         *        <p>
         *        Updates are applied during the next maintenance window because this can result in an outage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBackupRetention(Boolean enableBackupRetention);

        /**
         * <p>
         * When <code>true</code>, disables automated backup retention for your database.
         * </p>
         * <p>
         * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to
         * create a snapshot of your database using the <code>create relational database snapshot</code> operation.
         * </p>
         * <p>
         * Updates are applied during the next maintenance window because this can result in an outage.
         * </p>
         * 
         * @param disableBackupRetention
         *        When <code>true</code>, disables automated backup retention for your database.</p>
         *        <p>
         *        Disabling backup retention deletes all automated database backups. Before disabling this, you may want
         *        to create a snapshot of your database using the <code>create relational database snapshot</code>
         *        operation.
         *        </p>
         *        <p>
         *        Updates are applied during the next maintenance window because this can result in an outage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableBackupRetention(Boolean disableBackupRetention);

        /**
         * <p>
         * Specifies the accessibility options for your database. A value of <code>true</code> specifies a database that
         * is available to resources outside of your Lightsail account. A value of <code>false</code> specifies a
         * database that is available only to your Lightsail resources in the same region as your database.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for your database. A value of <code>true</code> specifies a
         *        database that is available to resources outside of your Lightsail account. A value of
         *        <code>false</code> specifies a database that is available only to your Lightsail resources in the same
         *        region as your database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during the
         * preferred maintenance window. Some changes may cause an outage.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param applyImmediately
         *        When <code>true</code>, applies changes immediately. When <code>false</code>, applies changes during
         *        the preferred maintenance window. Some changes may cause an outage.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String relationalDatabaseName;

        private String masterUserPassword;

        private Boolean rotateMasterUserPassword;

        private String preferredBackupWindow;

        private String preferredMaintenanceWindow;

        private Boolean enableBackupRetention;

        private Boolean disableBackupRetention;

        private Boolean publiclyAccessible;

        private Boolean applyImmediately;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRelationalDatabaseRequest model) {
            super(model);
            relationalDatabaseName(model.relationalDatabaseName);
            masterUserPassword(model.masterUserPassword);
            rotateMasterUserPassword(model.rotateMasterUserPassword);
            preferredBackupWindow(model.preferredBackupWindow);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            enableBackupRetention(model.enableBackupRetention);
            disableBackupRetention(model.disableBackupRetention);
            publiclyAccessible(model.publiclyAccessible);
            applyImmediately(model.applyImmediately);
        }

        public final String getRelationalDatabaseName() {
            return relationalDatabaseName;
        }

        @Override
        public final Builder relationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
            return this;
        }

        public final void setRelationalDatabaseName(String relationalDatabaseName) {
            this.relationalDatabaseName = relationalDatabaseName;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final Boolean getRotateMasterUserPassword() {
            return rotateMasterUserPassword;
        }

        @Override
        public final Builder rotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
            return this;
        }

        public final void setRotateMasterUserPassword(Boolean rotateMasterUserPassword) {
            this.rotateMasterUserPassword = rotateMasterUserPassword;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getEnableBackupRetention() {
            return enableBackupRetention;
        }

        @Override
        public final Builder enableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
            return this;
        }

        public final void setEnableBackupRetention(Boolean enableBackupRetention) {
            this.enableBackupRetention = enableBackupRetention;
        }

        public final Boolean getDisableBackupRetention() {
            return disableBackupRetention;
        }

        @Override
        public final Builder disableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
            return this;
        }

        public final void setDisableBackupRetention(Boolean disableBackupRetention) {
            this.disableBackupRetention = disableBackupRetention;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRelationalDatabaseRequest build() {
            return new UpdateRelationalDatabaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
