/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoadBalancerResponse extends LightsailResponse implements
        ToCopyableBuilder<GetLoadBalancerResponse.Builder, GetLoadBalancerResponse> {
    private static final SdkField<LoadBalancer> LOAD_BALANCER_FIELD = SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetLoadBalancerResponse::loadBalancer)).setter(setter(Builder::loadBalancer))
            .constructor(LoadBalancer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_FIELD));

    private final LoadBalancer loadBalancer;

    private GetLoadBalancerResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancer = builder.loadBalancer;
    }

    /**
     * <p>
     * An object containing information about your load balancer.
     * </p>
     * 
     * @return An object containing information about your load balancer.
     */
    public LoadBalancer loadBalancer() {
        return loadBalancer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancer());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoadBalancerResponse)) {
            return false;
        }
        GetLoadBalancerResponse other = (GetLoadBalancerResponse) obj;
        return Objects.equals(loadBalancer(), other.loadBalancer());
    }

    @Override
    public String toString() {
        return ToString.builder("GetLoadBalancerResponse").add("LoadBalancer", loadBalancer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadBalancer":
            return Optional.ofNullable(clazz.cast(loadBalancer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoadBalancerResponse, T> g) {
        return obj -> g.apply((GetLoadBalancerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLoadBalancerResponse> {
        /**
         * <p>
         * An object containing information about your load balancer.
         * </p>
         * 
         * @param loadBalancer
         *        An object containing information about your load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancer(LoadBalancer loadBalancer);

        /**
         * <p>
         * An object containing information about your load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link LoadBalancer.Builder} avoiding the need to
         * create one manually via {@link LoadBalancer#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoadBalancer.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancer(LoadBalancer)}.
         * 
         * @param loadBalancer
         *        a consumer that will call methods on {@link LoadBalancer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancer(LoadBalancer)
         */
        default Builder loadBalancer(Consumer<LoadBalancer.Builder> loadBalancer) {
            return loadBalancer(LoadBalancer.builder().applyMutation(loadBalancer).build());
        }
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private LoadBalancer loadBalancer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoadBalancerResponse model) {
            super(model);
            loadBalancer(model.loadBalancer);
        }

        public final LoadBalancer.Builder getLoadBalancer() {
            return loadBalancer != null ? loadBalancer.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancer(LoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public final void setLoadBalancer(LoadBalancer.BuilderImpl loadBalancer) {
            this.loadBalancer = loadBalancer != null ? loadBalancer.build() : null;
        }

        @Override
        public GetLoadBalancerResponse build() {
            return new GetLoadBalancerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
