/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOperationsForResourceResponse extends LightsailResponse implements
        ToCopyableBuilder<GetOperationsForResourceResponse.Builder, GetOperationsForResourceResponse> {
    private static final SdkField<List<Operation>> OPERATIONS_FIELD = SdkField
            .<List<Operation>> builder(MarshallingType.LIST)
            .getter(getter(GetOperationsForResourceResponse::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Operation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Operation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOperationsForResourceResponse::nextPageCount)).setter(setter(Builder::nextPageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageCount").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOperationsForResourceResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD,
            NEXT_PAGE_COUNT_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final List<Operation> operations;

    private final String nextPageCount;

    private final String nextPageToken;

    private GetOperationsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextPageCount = builder.nextPageCount;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get operations for resource request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get operations for resource
     *         request.
     */
    public List<Operation> operations() {
        return operations;
    }

    /**
     * <p>
     * (Deprecated) Returns the number of pages of results that remain.
     * </p>
     * <note>
     * <p>
     * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now deprecated,
     * and the API returns the <code>next page token</code> parameter instead.
     * </p>
     * </note>
     * 
     * @return (Deprecated) Returns the number of pages of results that remain.</p> <note>
     *         <p>
     *         In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
     *         deprecated, and the API returns the <code>next page token</code> parameter instead.
     *         </p>
     */
    public String nextPageCount() {
        return nextPageCount;
    }

    /**
     * <p>
     * An identifier that was returned from the previous call to this operation, which can be used to return the next
     * set of items in the list.
     * </p>
     * 
     * @return An identifier that was returned from the previous call to this operation, which can be used to return the
     *         next set of items in the list.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageCount());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationsForResourceResponse)) {
            return false;
        }
        GetOperationsForResourceResponse other = (GetOperationsForResourceResponse) obj;
        return Objects.equals(operations(), other.operations()) && Objects.equals(nextPageCount(), other.nextPageCount())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOperationsForResourceResponse").add("Operations", operations())
                .add("NextPageCount", nextPageCount()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "nextPageCount":
            return Optional.ofNullable(clazz.cast(nextPageCount()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOperationsForResourceResponse, T> g) {
        return obj -> g.apply((GetOperationsForResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOperationsForResourceResponse> {
        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations for resource
         * request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations for
         *        resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<Operation> operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations for resource
         * request.
         * </p>
         * 
         * @param operations
         *        An array of key-value pairs containing information about the results of your get operations for
         *        resource request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Operation... operations);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get operations for resource
         * request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Operation>.Builder} avoiding the need to
         * create one manually via {@link List<Operation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Operation>.Builder#build()} is called immediately and its
         * result is passed to {@link #operations(List<Operation>)}.
         * 
         * @param operations
         *        a consumer that will call methods on {@link List<Operation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #operations(List<Operation>)
         */
        Builder operations(Consumer<Operation.Builder>... operations);

        /**
         * <p>
         * (Deprecated) Returns the number of pages of results that remain.
         * </p>
         * <note>
         * <p>
         * In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         * deprecated, and the API returns the <code>next page token</code> parameter instead.
         * </p>
         * </note>
         * 
         * @param nextPageCount
         *        (Deprecated) Returns the number of pages of results that remain.</p> <note>
         *        <p>
         *        In releases prior to June 12, 2017, this parameter returned <code>null</code> by the API. It is now
         *        deprecated, and the API returns the <code>next page token</code> parameter instead.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageCount(String nextPageCount);

        /**
         * <p>
         * An identifier that was returned from the previous call to this operation, which can be used to return the
         * next set of items in the list.
         * </p>
         * 
         * @param nextPageToken
         *        An identifier that was returned from the previous call to this operation, which can be used to return
         *        the next set of items in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Operation> operations = DefaultSdkAutoConstructList.getInstance();

        private String nextPageCount;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationsForResourceResponse model) {
            super(model);
            operations(model.operations);
            nextPageCount(model.nextPageCount);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Operation.Builder> getOperations() {
            return operations != null ? operations.stream().map(Operation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operations(Collection<Operation> operations) {
            this.operations = OperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Operation... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<Operation.Builder>... operations) {
            operations(Stream.of(operations).map(c -> Operation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperations(Collection<Operation.BuilderImpl> operations) {
            this.operations = OperationListCopier.copyFromBuilder(operations);
        }

        public final String getNextPageCount() {
            return nextPageCount;
        }

        @Override
        public final Builder nextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
            return this;
        }

        public final void setNextPageCount(String nextPageCount) {
            this.nextPageCount = nextPageCount;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetOperationsForResourceResponse build() {
            return new GetOperationsForResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
