/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the port state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstancePortState implements SdkPojo, Serializable,
        ToCopyableBuilder<InstancePortState.Builder, InstancePortState> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstancePortState::fromPort)).setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstancePortState::toPort)).setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toPort").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancePortState::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstancePortState::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD,
            TO_PORT_FIELD, PROTOCOL_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fromPort;

    private final Integer toPort;

    private final String protocol;

    private final String state;

    private InstancePortState(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.protocol = builder.protocol;
        this.state = builder.state;
    }

    /**
     * <p>
     * The first port in the range.
     * </p>
     * 
     * @return The first port in the range.
     */
    public Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The last port in the range.
     * </p>
     * 
     * @return The last port in the range.
     */
    public Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The protocol being used. Can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of
     * streamed data between applications running on hosts communicating by an IP network. If you have an application
     * that doesn't require reliable data stream service, use UDP instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> - All transport layer protocol types. For more general information, see <a
     * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to
     * other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission
     * channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides
     * a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable
     * data stream service, use TCP instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol being used. Can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
     *         delivery of streamed data between applications running on hosts communicating by an IP network. If you
     *         have an application that doesn't require reliable data stream service, use UDP instead.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> - All transport layer protocol types. For more general information, see <a
     *         href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
     *         datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to
     *         set up transmission channels or data paths. Applications that don't require reliable data stream service
     *         can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over
     *         reliability. If you do require reliable data stream service, use TCP instead.
     *         </p>
     *         </li>
     * @see NetworkProtocol
     */
    public NetworkProtocol protocol() {
        return NetworkProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol being used. Can be one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery of
     * streamed data between applications running on hosts communicating by an IP network. If you have an application
     * that doesn't require reliable data stream service, use UDP instead.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>all</code> - All transport layer protocol types. For more general information, see <a
     * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams) to
     * other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up transmission
     * channels or data paths. Applications that don't require reliable data stream service can use UDP, which provides
     * a connectionless datagram service that emphasizes reduced latency over reliability. If you do require reliable
     * data stream service, use TCP instead.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link NetworkProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol being used. Can be one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
     *         delivery of streamed data between applications running on hosts communicating by an IP network. If you
     *         have an application that doesn't require reliable data stream service, use UDP instead.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>all</code> - All transport layer protocol types. For more general information, see <a
     *         href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
     *         datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required to
     *         set up transmission channels or data paths. Applications that don't require reliable data stream service
     *         can use UDP, which provides a connectionless datagram service that emphasizes reduced latency over
     *         reliability. If you do require reliable data stream service, use TCP instead.
     *         </p>
     *         </li>
     * @see NetworkProtocol
     */
    public String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PortState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * @see PortState
     */
    public PortState state() {
        return PortState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PortState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the instance port is <code>open</code> or <code>closed</code>.
     * @see PortState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePortState)) {
            return false;
        }
        InstancePortState other = (InstancePortState) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(toPort(), other.toPort())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InstancePortState").add("FromPort", fromPort()).add("ToPort", toPort())
                .add("Protocol", protocolAsString()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "toPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstancePortState, T> g) {
        return obj -> g.apply((InstancePortState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstancePortState> {
        /**
         * <p>
         * The first port in the range.
         * </p>
         * 
         * @param fromPort
         *        The first port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The last port in the range.
         * </p>
         * 
         * @param toPort
         *        The last port in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol being used. Can be one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked delivery
         * of streamed data between applications running on hosts communicating by an IP network. If you have an
         * application that doesn't require reliable data stream service, use UDP instead.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>all</code> - All transport layer protocol types. For more general information, see <a
         * href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or datagrams)
         * to other hosts on an Internet Protocol (IP) network. Prior communications are not required to set up
         * transmission channels or data paths. Applications that don't require reliable data stream service can use
         * UDP, which provides a connectionless datagram service that emphasizes reduced latency over reliability. If
         * you do require reliable data stream service, use TCP instead.
         * </p>
         * </li>
         * </ul>
         * 
         * @param protocol
         *        The protocol being used. Can be one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>tcp</code> - Transmission Control Protocol (TCP) provides reliable, ordered, and error-checked
         *        delivery of streamed data between applications running on hosts communicating by an IP network. If you
         *        have an application that doesn't require reliable data stream service, use UDP instead.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>all</code> - All transport layer protocol types. For more general information, see <a
         *        href="https://en.wikipedia.org/wiki/Transport_layer">Transport layer</a> on Wikipedia.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>udp</code> - With User Datagram Protocol (UDP), computer applications can send messages (or
         *        datagrams) to other hosts on an Internet Protocol (IP) network. Prior communications are not required
         *        to set up transmission channels or data paths. Applications that don't require reliable data stream
         *        service can use UDP, which provides a connectionless datagram service that emphasizes reduced latency
         *        over reliability. If you do require reliable data stream service, use TCP instead.
         *        </p>
         *        </li>
         * @see NetworkProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkProtocol
         */
        Builder protocol(NetworkProtocol protocol);

        /**
         * <p>
         * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * </p>
         * 
         * @param state
         *        Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * @see PortState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * </p>
         * 
         * @param state
         *        Specifies whether the instance port is <code>open</code> or <code>closed</code>.
         * @see PortState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortState
         */
        Builder state(PortState state);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private Integer toPort;

        private String protocol;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePortState model) {
            fromPort(model.fromPort);
            toPort(model.toPort);
            protocol(model.protocol);
            state(model.state);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(NetworkProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PortState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public InstancePortState build() {
            return new InstancePortState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
