/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of Lightsail's managed renewal for the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateRenewalSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificateRenewalSummary.Builder, LoadBalancerTlsCertificateRenewalSummary> {
    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerTlsCertificateRenewalSummary::renewalStatusAsString))
            .setter(setter(Builder::renewalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalStatus").build()).build();

    private static final SdkField<List<LoadBalancerTlsCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField
            .<List<LoadBalancerTlsCertificateDomainValidationOption>> builder(MarshallingType.LIST)
            .getter(getter(LoadBalancerTlsCertificateRenewalSummary::domainValidationOptions))
            .setter(setter(Builder::domainValidationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerTlsCertificateDomainValidationOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerTlsCertificateDomainValidationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENEWAL_STATUS_FIELD,
            DOMAIN_VALIDATION_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String renewalStatus;

    private final List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions;

    private LoadBalancerTlsCertificateRenewalSummary(BuilderImpl builder) {
        this.renewalStatus = builder.renewalStatus;
        this.domainValidationOptions = builder.domainValidationOptions;
    }

    /**
     * <p>
     * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public LoadBalancerTlsCertificateRenewalStatus renewalStatus() {
        return LoadBalancerTlsCertificateRenewalStatus.fromValue(renewalStatus);
    }

    /**
     * <p>
     * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #renewalStatus}
     * will return {@link LoadBalancerTlsCertificateRenewalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #renewalStatusAsString}.
     * </p>
     * 
     * @return The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
     * @see LoadBalancerTlsCertificateRenewalStatus
     */
    public String renewalStatusAsString() {
        return renewalStatus;
    }

    /**
     * <p>
     * Contains information about the validation of each domain name in the certificate, as it pertains to Lightsail's
     * managed renewal. This is different from the initial validation that occurs as a result of the RequestCertificate
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains information about the validation of each domain name in the certificate, as it pertains to
     *         Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
     *         RequestCertificate request.
     */
    public List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions() {
        return domainValidationOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(domainValidationOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateRenewalSummary)) {
            return false;
        }
        LoadBalancerTlsCertificateRenewalSummary other = (LoadBalancerTlsCertificateRenewalSummary) obj;
        return Objects.equals(renewalStatusAsString(), other.renewalStatusAsString())
                && Objects.equals(domainValidationOptions(), other.domainValidationOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadBalancerTlsCertificateRenewalSummary").add("RenewalStatus", renewalStatusAsString())
                .add("DomainValidationOptions", domainValidationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "renewalStatus":
            return Optional.ofNullable(clazz.cast(renewalStatusAsString()));
        case "domainValidationOptions":
            return Optional.ofNullable(clazz.cast(domainValidationOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateRenewalSummary, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateRenewalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificateRenewalSummary> {
        /**
         * <p>
         * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * </p>
         * 
         * @param renewalStatus
         *        The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(String renewalStatus);

        /**
         * <p>
         * The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * </p>
         * 
         * @param renewalStatus
         *        The status of Lightsail's managed renewal of the certificate. Valid values are listed below.
         * @see LoadBalancerTlsCertificateRenewalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoadBalancerTlsCertificateRenewalStatus
         */
        Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * 
         * @param domainValidationOptions
         *        Contains information about the validation of each domain name in the certificate, as it pertains to
         *        Lightsail's managed renewal. This is different from the initial validation that occurs as a result of
         *        the RequestCertificate request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions);

        /**
         * <p>
         * Contains information about the validation of each domain name in the certificate, as it pertains to
         * Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the
         * RequestCertificate request.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder} avoiding the need to create one manually via
         * {@link List<LoadBalancerTlsCertificateDomainValidationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <LoadBalancerTlsCertificateDomainValidationOption>.Builder#build()} is called immediately and its result is
         * passed to {@link #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)}.
         * 
         * @param domainValidationOptions
         *        a consumer that will call methods on {@link List
         *        <LoadBalancerTlsCertificateDomainValidationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationOptions(List<LoadBalancerTlsCertificateDomainValidationOption>)
         */
        Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions);
    }

    static final class BuilderImpl implements Builder {
        private String renewalStatus;

        private List<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateRenewalSummary model) {
            renewalStatus(model.renewalStatus);
            domainValidationOptions(model.domainValidationOptions);
        }

        public final String getRenewalStatus() {
            return renewalStatus;
        }

        @Override
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        @Override
        public final Builder renewalStatus(LoadBalancerTlsCertificateRenewalStatus renewalStatus) {
            this.renewalStatus(renewalStatus.toString());
            return this;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        public final Collection<LoadBalancerTlsCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            return domainValidationOptions != null ? domainValidationOptions.stream()
                    .map(LoadBalancerTlsCertificateDomainValidationOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copy(domainValidationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(LoadBalancerTlsCertificateDomainValidationOption... domainValidationOptions) {
            domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationOptions(
                Consumer<LoadBalancerTlsCertificateDomainValidationOption.Builder>... domainValidationOptions) {
            domainValidationOptions(Stream.of(domainValidationOptions)
                    .map(c -> LoadBalancerTlsCertificateDomainValidationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationOptions(
                Collection<LoadBalancerTlsCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = LoadBalancerTlsCertificateDomainValidationOptionListCopier
                    .copyFromBuilder(domainValidationOptions);
        }

        @Override
        public LoadBalancerTlsCertificateRenewalSummary build() {
            return new LoadBalancerTlsCertificateRenewalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
