/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum OperationType {
    DELETE_INSTANCE("DeleteInstance"),

    CREATE_INSTANCE("CreateInstance"),

    STOP_INSTANCE("StopInstance"),

    START_INSTANCE("StartInstance"),

    REBOOT_INSTANCE("RebootInstance"),

    OPEN_INSTANCE_PUBLIC_PORTS("OpenInstancePublicPorts"),

    PUT_INSTANCE_PUBLIC_PORTS("PutInstancePublicPorts"),

    CLOSE_INSTANCE_PUBLIC_PORTS("CloseInstancePublicPorts"),

    ALLOCATE_STATIC_IP("AllocateStaticIp"),

    RELEASE_STATIC_IP("ReleaseStaticIp"),

    ATTACH_STATIC_IP("AttachStaticIp"),

    DETACH_STATIC_IP("DetachStaticIp"),

    UPDATE_DOMAIN_ENTRY("UpdateDomainEntry"),

    DELETE_DOMAIN_ENTRY("DeleteDomainEntry"),

    CREATE_DOMAIN("CreateDomain"),

    DELETE_DOMAIN("DeleteDomain"),

    CREATE_INSTANCE_SNAPSHOT("CreateInstanceSnapshot"),

    DELETE_INSTANCE_SNAPSHOT("DeleteInstanceSnapshot"),

    CREATE_INSTANCES_FROM_SNAPSHOT("CreateInstancesFromSnapshot"),

    CREATE_LOAD_BALANCER("CreateLoadBalancer"),

    DELETE_LOAD_BALANCER("DeleteLoadBalancer"),

    ATTACH_INSTANCES_TO_LOAD_BALANCER("AttachInstancesToLoadBalancer"),

    DETACH_INSTANCES_FROM_LOAD_BALANCER("DetachInstancesFromLoadBalancer"),

    UPDATE_LOAD_BALANCER_ATTRIBUTE("UpdateLoadBalancerAttribute"),

    CREATE_LOAD_BALANCER_TLS_CERTIFICATE("CreateLoadBalancerTlsCertificate"),

    DELETE_LOAD_BALANCER_TLS_CERTIFICATE("DeleteLoadBalancerTlsCertificate"),

    ATTACH_LOAD_BALANCER_TLS_CERTIFICATE("AttachLoadBalancerTlsCertificate"),

    CREATE_DISK("CreateDisk"),

    DELETE_DISK("DeleteDisk"),

    ATTACH_DISK("AttachDisk"),

    DETACH_DISK("DetachDisk"),

    CREATE_DISK_SNAPSHOT("CreateDiskSnapshot"),

    DELETE_DISK_SNAPSHOT("DeleteDiskSnapshot"),

    CREATE_DISK_FROM_SNAPSHOT("CreateDiskFromSnapshot"),

    CREATE_RELATIONAL_DATABASE("CreateRelationalDatabase"),

    UPDATE_RELATIONAL_DATABASE("UpdateRelationalDatabase"),

    DELETE_RELATIONAL_DATABASE("DeleteRelationalDatabase"),

    CREATE_RELATIONAL_DATABASE_FROM_SNAPSHOT("CreateRelationalDatabaseFromSnapshot"),

    CREATE_RELATIONAL_DATABASE_SNAPSHOT("CreateRelationalDatabaseSnapshot"),

    DELETE_RELATIONAL_DATABASE_SNAPSHOT("DeleteRelationalDatabaseSnapshot"),

    UPDATE_RELATIONAL_DATABASE_PARAMETERS("UpdateRelationalDatabaseParameters"),

    START_RELATIONAL_DATABASE("StartRelationalDatabase"),

    REBOOT_RELATIONAL_DATABASE("RebootRelationalDatabase"),

    STOP_RELATIONAL_DATABASE("StopRelationalDatabase"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OperationType corresponding to the value
     */
    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OperationType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OperationType}s
     */
    public static Set<OperationType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
