/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a pending database value modification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingModifiedRelationalDatabaseValues implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingModifiedRelationalDatabaseValues.Builder, PendingModifiedRelationalDatabaseValues> {
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PendingModifiedRelationalDatabaseValues::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterUserPassword").build())
            .build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PendingModifiedRelationalDatabaseValues::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<Boolean> BACKUP_RETENTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PendingModifiedRelationalDatabaseValues::backupRetentionEnabled))
            .setter(setter(Builder::backupRetentionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupRetentionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_USER_PASSWORD_FIELD,
            ENGINE_VERSION_FIELD, BACKUP_RETENTION_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String masterUserPassword;

    private final String engineVersion;

    private final Boolean backupRetentionEnabled;

    private PendingModifiedRelationalDatabaseValues(BuilderImpl builder) {
        this.masterUserPassword = builder.masterUserPassword;
        this.engineVersion = builder.engineVersion;
        this.backupRetentionEnabled = builder.backupRetentionEnabled;
    }

    /**
     * <p>
     * The password for the master user of the database.
     * </p>
     * 
     * @return The password for the master user of the database.
     */
    public String masterUserPassword() {
        return masterUserPassword;
    }

    /**
     * <p>
     * The database engine version.
     * </p>
     * 
     * @return The database engine version.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * A Boolean value indicating whether automated backup retention is enabled.
     * </p>
     * 
     * @return A Boolean value indicating whether automated backup retention is enabled.
     */
    public Boolean backupRetentionEnabled() {
        return backupRetentionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingModifiedRelationalDatabaseValues)) {
            return false;
        }
        PendingModifiedRelationalDatabaseValues other = (PendingModifiedRelationalDatabaseValues) obj;
        return Objects.equals(masterUserPassword(), other.masterUserPassword())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(backupRetentionEnabled(), other.backupRetentionEnabled());
    }

    @Override
    public String toString() {
        return ToString.builder("PendingModifiedRelationalDatabaseValues").add("MasterUserPassword", masterUserPassword())
                .add("EngineVersion", engineVersion()).add("BackupRetentionEnabled", backupRetentionEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "masterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "backupRetentionEnabled":
            return Optional.ofNullable(clazz.cast(backupRetentionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingModifiedRelationalDatabaseValues, T> g) {
        return obj -> g.apply((PendingModifiedRelationalDatabaseValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingModifiedRelationalDatabaseValues> {
        /**
         * <p>
         * The password for the master user of the database.
         * </p>
         * 
         * @param masterUserPassword
         *        The password for the master user of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);

        /**
         * <p>
         * The database engine version.
         * </p>
         * 
         * @param engineVersion
         *        The database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * A Boolean value indicating whether automated backup retention is enabled.
         * </p>
         * 
         * @param backupRetentionEnabled
         *        A Boolean value indicating whether automated backup retention is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionEnabled(Boolean backupRetentionEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String masterUserPassword;

        private String engineVersion;

        private Boolean backupRetentionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingModifiedRelationalDatabaseValues model) {
            masterUserPassword(model.masterUserPassword);
            engineVersion(model.engineVersion);
            backupRetentionEnabled(model.backupRetentionEnabled);
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getBackupRetentionEnabled() {
            return backupRetentionEnabled;
        }

        @Override
        public final Builder backupRetentionEnabled(Boolean backupRetentionEnabled) {
            this.backupRetentionEnabled = backupRetentionEnabled;
            return this;
        }

        public final void setBackupRetentionEnabled(Boolean backupRetentionEnabled) {
            this.backupRetentionEnabled = backupRetentionEnabled;
        }

        @Override
        public PendingModifiedRelationalDatabaseValues build() {
            return new PendingModifiedRelationalDatabaseValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
