/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopySnapshotRequest extends LightsailRequest implements
        ToCopyableBuilder<CopySnapshotRequest.Builder, CopySnapshotRequest> {
    private static final SdkField<String> SOURCE_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopySnapshotRequest::sourceSnapshotName)).setter(setter(Builder::sourceSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotName").build())
            .build();

    private static final SdkField<String> TARGET_SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopySnapshotRequest::targetSnapshotName)).setter(setter(Builder::targetSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSnapshotName").build())
            .build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopySnapshotRequest::sourceRegionAsString)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SNAPSHOT_NAME_FIELD,
            TARGET_SNAPSHOT_NAME_FIELD, SOURCE_REGION_FIELD));

    private final String sourceSnapshotName;

    private final String targetSnapshotName;

    private final String sourceRegion;

    private CopySnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.sourceSnapshotName = builder.sourceSnapshotName;
        this.targetSnapshotName = builder.targetSnapshotName;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * <p>
     * The name of the source instance or disk snapshot to be copied.
     * </p>
     * 
     * @return The name of the source instance or disk snapshot to be copied.
     */
    public String sourceSnapshotName() {
        return sourceSnapshotName;
    }

    /**
     * <p>
     * The name of the new instance or disk snapshot to be created as a copy.
     * </p>
     * 
     * @return The name of the new instance or disk snapshot to be created as a copy.
     */
    public String targetSnapshotName() {
        return targetSnapshotName;
    }

    /**
     * <p>
     * The AWS Region where the source snapshot is located.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRegion} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceRegionAsString}.
     * </p>
     * 
     * @return The AWS Region where the source snapshot is located.
     * @see RegionName
     */
    public RegionName sourceRegion() {
        return RegionName.fromValue(sourceRegion);
    }

    /**
     * <p>
     * The AWS Region where the source snapshot is located.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceRegion} will
     * return {@link RegionName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceRegionAsString}.
     * </p>
     * 
     * @return The AWS Region where the source snapshot is located.
     * @see RegionName
     */
    public String sourceRegionAsString() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest) obj;
        return Objects.equals(sourceSnapshotName(), other.sourceSnapshotName())
                && Objects.equals(targetSnapshotName(), other.targetSnapshotName())
                && Objects.equals(sourceRegionAsString(), other.sourceRegionAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("CopySnapshotRequest").add("SourceSnapshotName", sourceSnapshotName())
                .add("TargetSnapshotName", targetSnapshotName()).add("SourceRegion", sourceRegionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceSnapshotName":
            return Optional.ofNullable(clazz.cast(sourceSnapshotName()));
        case "targetSnapshotName":
            return Optional.ofNullable(clazz.cast(targetSnapshotName()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopySnapshotRequest, T> g) {
        return obj -> g.apply((CopySnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopySnapshotRequest> {
        /**
         * <p>
         * The name of the source instance or disk snapshot to be copied.
         * </p>
         * 
         * @param sourceSnapshotName
         *        The name of the source instance or disk snapshot to be copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotName(String sourceSnapshotName);

        /**
         * <p>
         * The name of the new instance or disk snapshot to be created as a copy.
         * </p>
         * 
         * @param targetSnapshotName
         *        The name of the new instance or disk snapshot to be created as a copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotName(String targetSnapshotName);

        /**
         * <p>
         * The AWS Region where the source snapshot is located.
         * </p>
         * 
         * @param sourceRegion
         *        The AWS Region where the source snapshot is located.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The AWS Region where the source snapshot is located.
         * </p>
         * 
         * @param sourceRegion
         *        The AWS Region where the source snapshot is located.
         * @see RegionName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionName
         */
        Builder sourceRegion(RegionName sourceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private String sourceSnapshotName;

        private String targetSnapshotName;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            super(model);
            sourceSnapshotName(model.sourceSnapshotName);
            targetSnapshotName(model.targetSnapshotName);
            sourceRegion(model.sourceRegion);
        }

        public final String getSourceSnapshotName() {
            return sourceSnapshotName;
        }

        @Override
        public final Builder sourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
            return this;
        }

        public final void setSourceSnapshotName(String sourceSnapshotName) {
            this.sourceSnapshotName = sourceSnapshotName;
        }

        public final String getTargetSnapshotName() {
            return targetSnapshotName;
        }

        @Override
        public final Builder targetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
            return this;
        }

        public final void setTargetSnapshotName(String targetSnapshotName) {
            this.targetSnapshotName = targetSnapshotName;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public final Builder sourceRegion(RegionName sourceRegion) {
            this.sourceRegion(sourceRegion.toString());
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
