/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInstanceMetricDataResponse extends LightsailResponse implements
        ToCopyableBuilder<GetInstanceMetricDataResponse.Builder, GetInstanceMetricDataResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetInstanceMetricDataResponse::metricNameAsString)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<List<MetricDatapoint>> METRIC_DATA_FIELD = SdkField
            .<List<MetricDatapoint>> builder(MarshallingType.LIST)
            .getter(getter(GetInstanceMetricDataResponse::metricData))
            .setter(setter(Builder::metricData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDatapoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDatapoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            METRIC_DATA_FIELD));

    private final String metricName;

    private final List<MetricDatapoint> metricData;

    private GetInstanceMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricData = builder.metricData;
    }

    /**
     * <p>
     * The metric name to return data for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link InstanceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric name to return data for.
     * @see InstanceMetricName
     */
    public InstanceMetricName metricName() {
        return InstanceMetricName.fromValue(metricName);
    }

    /**
     * <p>
     * The metric name to return data for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricName} will
     * return {@link InstanceMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #metricNameAsString}.
     * </p>
     * 
     * @return The metric name to return data for.
     * @see InstanceMetricName
     */
    public String metricNameAsString() {
        return metricName;
    }

    /**
     * Returns true if the MetricData property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMetricData() {
        return metricData != null && !(metricData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs containing information about the results of your get instance metric data request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs containing information about the results of your get instance metric data
     *         request.
     */
    public List<MetricDatapoint> metricData() {
        return metricData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceMetricDataResponse)) {
            return false;
        }
        GetInstanceMetricDataResponse other = (GetInstanceMetricDataResponse) obj;
        return Objects.equals(metricNameAsString(), other.metricNameAsString())
                && Objects.equals(metricData(), other.metricData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetInstanceMetricDataResponse").add("MetricName", metricNameAsString())
                .add("MetricData", metricData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricNameAsString()));
        case "metricData":
            return Optional.ofNullable(clazz.cast(metricData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceMetricDataResponse, T> g) {
        return obj -> g.apply((GetInstanceMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetInstanceMetricDataResponse> {
        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric name to return data for.
         * </p>
         * 
         * @param metricName
         *        The metric name to return data for.
         * @see InstanceMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetricName
         */
        Builder metricName(InstanceMetricName metricName);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(Collection<MetricDatapoint> metricData);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * 
         * @param metricData
         *        An array of key-value pairs containing information about the results of your get instance metric data
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricData(MetricDatapoint... metricData);

        /**
         * <p>
         * An array of key-value pairs containing information about the results of your get instance metric data
         * request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricDatapoint>.Builder} avoiding the need
         * to create one manually via {@link List<MetricDatapoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricDatapoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricData(List<MetricDatapoint>)}.
         * 
         * @param metricData
         *        a consumer that will call methods on {@link List<MetricDatapoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricData(List<MetricDatapoint>)
         */
        Builder metricData(Consumer<MetricDatapoint.Builder>... metricData);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private String metricName;

        private List<MetricDatapoint> metricData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceMetricDataResponse model) {
            super(model);
            metricName(model.metricName);
            metricData(model.metricData);
        }

        public final String getMetricNameAsString() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(InstanceMetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<MetricDatapoint.Builder> getMetricData() {
            return metricData != null ? metricData.stream().map(MetricDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatapoint> metricData) {
            this.metricData = MetricDatapointListCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatapoint... metricData) {
            metricData(Arrays.asList(metricData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(Consumer<MetricDatapoint.Builder>... metricData) {
            metricData(Stream.of(metricData).map(c -> MetricDatapoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricData(Collection<MetricDatapoint.BuilderImpl> metricData) {
            this.metricData = MetricDatapointListCopier.copyFromBuilder(metricData);
        }

        @Override
        public GetInstanceMetricDataResponse build() {
            return new GetInstanceMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
