/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::zoneName)).setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zoneName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_NAME_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String zoneName;

    private final String state;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.state = builder.state;
    }

    /**
     * <p>
     * The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
     * </p>
     * 
     * @return The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
     */
    public String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * 
     * @return The state of the Availability Zone.
     */
    public String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(zoneName(), other.zoneName()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AvailabilityZone").add("ZoneName", zoneName()).add("State", state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "zoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone. The format is <code>us-east-2a</code> (case-sensitive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String zoneName;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            zoneName(model.zoneName);
            state(model.state);
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
