/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block storage disk snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DiskSnapshot implements SdkPojo, Serializable, ToCopyableBuilder<DiskSnapshot.Builder, DiskSnapshot> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::supportCode)).setter(setter(Builder::supportCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DiskSnapshot::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField
            .<ResourceLocation> builder(MarshallingType.SDK_POJO).getter(getter(DiskSnapshot::location))
            .setter(setter(Builder::location)).constructor(ResourceLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DiskSnapshot::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DiskSnapshot::sizeInGb)).setter(setter(Builder::sizeInGb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progress").build()).build();

    private static final SdkField<String> FROM_DISK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::fromDiskName)).setter(setter(Builder::fromDiskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskName").build()).build();

    private static final SdkField<String> FROM_DISK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::fromDiskArn)).setter(setter(Builder::fromDiskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDiskArn").build()).build();

    private static final SdkField<String> FROM_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::fromInstanceName)).setter(setter(Builder::fromInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceName").build()).build();

    private static final SdkField<String> FROM_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DiskSnapshot::fromInstanceArn)).setter(setter(Builder::fromInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromInstanceArn").build()).build();

    private static final SdkField<Boolean> IS_FROM_AUTO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DiskSnapshot::isFromAutoSnapshot)).setter(setter(Builder::isFromAutoSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isFromAutoSnapshot").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, SIZE_IN_GB_FIELD, STATE_FIELD,
            PROGRESS_FIELD, FROM_DISK_NAME_FIELD, FROM_DISK_ARN_FIELD, FROM_INSTANCE_NAME_FIELD, FROM_INSTANCE_ARN_FIELD,
            IS_FROM_AUTO_SNAPSHOT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final String supportCode;

    private final Instant createdAt;

    private final ResourceLocation location;

    private final String resourceType;

    private final List<Tag> tags;

    private final Integer sizeInGb;

    private final String state;

    private final String progress;

    private final String fromDiskName;

    private final String fromDiskArn;

    private final String fromInstanceName;

    private final String fromInstanceArn;

    private final Boolean isFromAutoSnapshot;

    private DiskSnapshot(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.sizeInGb = builder.sizeInGb;
        this.state = builder.state;
        this.progress = builder.progress;
        this.fromDiskName = builder.fromDiskName;
        this.fromDiskArn = builder.fromDiskArn;
        this.fromInstanceName = builder.fromInstanceName;
        this.fromInstanceArn = builder.fromInstanceArn;
        this.isFromAutoSnapshot = builder.isFromAutoSnapshot;
    }

    /**
     * <p>
     * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     * </p>
     * 
     * @return The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the disk snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the disk snapshot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The support code. Include this code in your email to support when you have questions about an instance or another
     * resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     * </p>
     * 
     * @return The support code. Include this code in your email to support when you have questions about an instance or
     *         another resource in Lightsail. This code enables our support team to look up your Lightsail information
     *         more easily.
     */
    public String supportCode() {
        return supportCode;
    }

    /**
     * <p>
     * The date when the disk snapshot was created.
     * </p>
     * 
     * @return The date when the disk snapshot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS Region and Availability Zone where the disk snapshot was created.
     * </p>
     * 
     * @return The AWS Region and Availability Zone where the disk snapshot was created.
     */
    public ResourceLocation location() {
        return location;
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * @see ResourceType
     */
    public ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
     * @see ResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
     * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag keys and optional values for the resource. For more information about tags in Lightsail, see the
     *         <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
     *         Guide</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The size of the disk in GB.
     * </p>
     * 
     * @return The size of the disk in GB.
     */
    public Integer sizeInGb() {
        return sizeInGb;
    }

    /**
     * <p>
     * The status of the disk snapshot operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiskSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the disk snapshot operation.
     * @see DiskSnapshotState
     */
    public DiskSnapshotState state() {
        return DiskSnapshotState.fromValue(state);
    }

    /**
     * <p>
     * The status of the disk snapshot operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DiskSnapshotState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The status of the disk snapshot operation.
     * @see DiskSnapshotState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The progress of the disk snapshot operation.
     * </p>
     * 
     * @return The progress of the disk snapshot operation.
     */
    public String progress() {
        return progress;
    }

    /**
     * <p>
     * The unique name of the source disk from which the disk snapshot was created.
     * </p>
     * 
     * @return The unique name of the source disk from which the disk snapshot was created.
     */
    public String fromDiskName() {
        return fromDiskName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
     */
    public String fromDiskArn() {
        return fromDiskArn;
    }

    /**
     * <p>
     * The unique name of the source instance from which the disk (system volume) snapshot was created.
     * </p>
     * 
     * @return The unique name of the source instance from which the disk (system volume) snapshot was created.
     */
    public String fromInstanceName() {
        return fromInstanceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was
     *         created.
     */
    public String fromInstanceArn() {
        return fromInstanceArn;
    }

    /**
     * <p>
     * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
     * </p>
     * 
     * @return A Boolean value indicating whether the snapshot was created from an automatic snapshot.
     */
    public Boolean isFromAutoSnapshot() {
        return isFromAutoSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(fromDiskName());
        hashCode = 31 * hashCode + Objects.hashCode(fromDiskArn());
        hashCode = 31 * hashCode + Objects.hashCode(fromInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(fromInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(isFromAutoSnapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskSnapshot)) {
            return false;
        }
        DiskSnapshot other = (DiskSnapshot) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(supportCode(), other.supportCode()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(location(), other.location())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(tags(), other.tags())
                && Objects.equals(sizeInGb(), other.sizeInGb()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(progress(), other.progress()) && Objects.equals(fromDiskName(), other.fromDiskName())
                && Objects.equals(fromDiskArn(), other.fromDiskArn())
                && Objects.equals(fromInstanceName(), other.fromInstanceName())
                && Objects.equals(fromInstanceArn(), other.fromInstanceArn())
                && Objects.equals(isFromAutoSnapshot(), other.isFromAutoSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DiskSnapshot").add("Name", name()).add("Arn", arn()).add("SupportCode", supportCode())
                .add("CreatedAt", createdAt()).add("Location", location()).add("ResourceType", resourceTypeAsString())
                .add("Tags", tags()).add("SizeInGb", sizeInGb()).add("State", stateAsString()).add("Progress", progress())
                .add("FromDiskName", fromDiskName()).add("FromDiskArn", fromDiskArn())
                .add("FromInstanceName", fromInstanceName()).add("FromInstanceArn", fromInstanceArn())
                .add("IsFromAutoSnapshot", isFromAutoSnapshot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "supportCode":
            return Optional.ofNullable(clazz.cast(supportCode()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "sizeInGb":
            return Optional.ofNullable(clazz.cast(sizeInGb()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "progress":
            return Optional.ofNullable(clazz.cast(progress()));
        case "fromDiskName":
            return Optional.ofNullable(clazz.cast(fromDiskName()));
        case "fromDiskArn":
            return Optional.ofNullable(clazz.cast(fromDiskArn()));
        case "fromInstanceName":
            return Optional.ofNullable(clazz.cast(fromInstanceName()));
        case "fromInstanceArn":
            return Optional.ofNullable(clazz.cast(fromInstanceArn()));
        case "isFromAutoSnapshot":
            return Optional.ofNullable(clazz.cast(isFromAutoSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskSnapshot, T> g) {
        return obj -> g.apply((DiskSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DiskSnapshot> {
        /**
         * <p>
         * The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * </p>
         * 
         * @param name
         *        The name of the disk snapshot (e.g., <code>my-disk-snapshot</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the disk snapshot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the disk snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The support code. Include this code in your email to support when you have questions about an instance or
         * another resource in Lightsail. This code enables our support team to look up your Lightsail information more
         * easily.
         * </p>
         * 
         * @param supportCode
         *        The support code. Include this code in your email to support when you have questions about an instance
         *        or another resource in Lightsail. This code enables our support team to look up your Lightsail
         *        information more easily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportCode(String supportCode);

        /**
         * <p>
         * The date when the disk snapshot was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS Region and Availability Zone where the disk snapshot was created.
         * </p>
         * 
         * @param location
         *        The AWS Region and Availability Zone where the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(ResourceLocation location);

        /**
         * <p>
         * The AWS Region and Availability Zone where the disk snapshot was created.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceLocation.Builder} avoiding the need to
         * create one manually via {@link ResourceLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #location(ResourceLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link ResourceLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(ResourceLocation)
         */
        default Builder location(Consumer<ResourceLocation.Builder> location) {
            return location(ResourceLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * </p>
         * 
         * @param resourceType
         *        The Lightsail resource type (e.g., <code>DiskSnapshot</code>).
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource. For more information about tags in Lightsail, see
         *        the <a href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the <a
         * href="https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags">Lightsail Dev Guide</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The size of the disk in GB.
         * </p>
         * 
         * @param sizeInGb
         *        The size of the disk in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGb(Integer sizeInGb);

        /**
         * <p>
         * The status of the disk snapshot operation.
         * </p>
         * 
         * @param state
         *        The status of the disk snapshot operation.
         * @see DiskSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskSnapshotState
         */
        Builder state(String state);

        /**
         * <p>
         * The status of the disk snapshot operation.
         * </p>
         * 
         * @param state
         *        The status of the disk snapshot operation.
         * @see DiskSnapshotState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskSnapshotState
         */
        Builder state(DiskSnapshotState state);

        /**
         * <p>
         * The progress of the disk snapshot operation.
         * </p>
         * 
         * @param progress
         *        The progress of the disk snapshot operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);

        /**
         * <p>
         * The unique name of the source disk from which the disk snapshot was created.
         * </p>
         * 
         * @param fromDiskName
         *        The unique name of the source disk from which the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskName(String fromDiskName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
         * </p>
         * 
         * @param fromDiskArn
         *        The Amazon Resource Name (ARN) of the source disk from which the disk snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDiskArn(String fromDiskArn);

        /**
         * <p>
         * The unique name of the source instance from which the disk (system volume) snapshot was created.
         * </p>
         * 
         * @param fromInstanceName
         *        The unique name of the source instance from which the disk (system volume) snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromInstanceName(String fromInstanceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was
         * created.
         * </p>
         * 
         * @param fromInstanceArn
         *        The Amazon Resource Name (ARN) of the source instance from which the disk (system volume) snapshot was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromInstanceArn(String fromInstanceArn);

        /**
         * <p>
         * A Boolean value indicating whether the snapshot was created from an automatic snapshot.
         * </p>
         * 
         * @param isFromAutoSnapshot
         *        A Boolean value indicating whether the snapshot was created from an automatic snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isFromAutoSnapshot(Boolean isFromAutoSnapshot);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private String supportCode;

        private Instant createdAt;

        private ResourceLocation location;

        private String resourceType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Integer sizeInGb;

        private String state;

        private String progress;

        private String fromDiskName;

        private String fromDiskArn;

        private String fromInstanceName;

        private String fromInstanceArn;

        private Boolean isFromAutoSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskSnapshot model) {
            name(model.name);
            arn(model.arn);
            supportCode(model.supportCode);
            createdAt(model.createdAt);
            location(model.location);
            resourceType(model.resourceType);
            tags(model.tags);
            sizeInGb(model.sizeInGb);
            state(model.state);
            progress(model.progress);
            fromDiskName(model.fromDiskName);
            fromDiskArn(model.fromDiskArn);
            fromInstanceName(model.fromInstanceName);
            fromInstanceArn(model.fromInstanceArn);
            isFromAutoSnapshot(model.isFromAutoSnapshot);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceTypeAsString() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Integer getSizeInGb() {
            return sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiskSnapshotState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getFromDiskName() {
            return fromDiskName;
        }

        @Override
        public final Builder fromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
            return this;
        }

        public final void setFromDiskName(String fromDiskName) {
            this.fromDiskName = fromDiskName;
        }

        public final String getFromDiskArn() {
            return fromDiskArn;
        }

        @Override
        public final Builder fromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
            return this;
        }

        public final void setFromDiskArn(String fromDiskArn) {
            this.fromDiskArn = fromDiskArn;
        }

        public final String getFromInstanceName() {
            return fromInstanceName;
        }

        @Override
        public final Builder fromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
            return this;
        }

        public final void setFromInstanceName(String fromInstanceName) {
            this.fromInstanceName = fromInstanceName;
        }

        public final String getFromInstanceArn() {
            return fromInstanceArn;
        }

        @Override
        public final Builder fromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
            return this;
        }

        public final void setFromInstanceArn(String fromInstanceArn) {
            this.fromInstanceArn = fromInstanceArn;
        }

        public final Boolean getIsFromAutoSnapshot() {
            return isFromAutoSnapshot;
        }

        @Override
        public final Builder isFromAutoSnapshot(Boolean isFromAutoSnapshot) {
            this.isFromAutoSnapshot = isFromAutoSnapshot;
            return this;
        }

        public final void setIsFromAutoSnapshot(Boolean isFromAutoSnapshot) {
            this.isFromAutoSnapshot = isFromAutoSnapshot;
        }

        @Override
        public DiskSnapshot build() {
            return new DiskSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
